/*
 * JBoss, Home of Professional Open Source
 * Copyright 2012, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.soap.wise;

import it.javalinux.wise.core.client.WSDynamicClient;
import it.javalinux.wise.core.utils.WiseProperties;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.wsf.spi.tools.WSContractConsumer;

/**
 * Aspect used to add jaxb binding files for WSConsume.
 * 
 * @author <a href='mailto:mbojan@jboss.com'>Magesh Kumar B</a>
 */
public class WSDynamicClientJaxbAspect
{
    public Object importObjectFromWsdl(final MethodInvocation invocation) throws Throwable
    {
        WSDynamicClient client = (WSDynamicClient) invocation.getTargetObject();
        Field field = client.getClass().getDeclaredField("wiseProperties");
        field.setAccessible(true);
        WiseProperties wiseProperties = (WiseProperties) field.get(client);

        final Object[] args = invocation.getArguments();
        final String wsdlURL = (String) args[0];
        final File outputDir = (File) args[1];
        final File sourceDir = (File) args[2];
        final String targetPackage = (String) args[3];

        WSContractConsumer wsImporter = WSContractConsumer.newInstance(Thread.currentThread().getContextClassLoader());
        wsImporter.setGenerateSource(Boolean.parseBoolean(wiseProperties.getProperty("wise.keepGeneratedSources", "false")));
        wsImporter.setOutputDirectory(outputDir);
        wsImporter.setSourceDirectory(sourceDir);
        if (Boolean.parseBoolean(wiseProperties.getProperty("wise.wsImporter.verbose"))) {
            wsImporter.setMessageStream(System.out);
        }
        wsImporter.setTargetPackage(targetPackage);
        String bindingsProp = wiseProperties.getProperty("wise.jaxb.bindings");
        String tempDir = wiseProperties.getProperty("wise.tmpDir");
        if (bindingsProp != null && !bindingsProp.trim().equals(""))
        {
            String[] bindings = bindingsProp.split(",");
            List<File> bindingFiles = new ArrayList<File>();
            for (String binding : bindings)
            {
                URL url = Thread.currentThread().getContextClassLoader().getResource(binding);
                String protocol = url.getProtocol();
                URI fileName = url.toURI();
                if (!protocol.equals("file")) {
                    // Move to temp dir from the archive
                    fileName = transferBindingFile(tempDir, url, binding);
                }
                bindingFiles.add(new File(fileName));
            }
            if (bindingFiles.size() > 0)
            {
                wsImporter.setBindingFiles(bindingFiles);
            }
        }
        wsImporter.consume(wsdlURL);

        return null;
    }

    private URI transferBindingFile(String tempDir, URL source, String fileName) throws Exception
    {
        InputStream is = source.openStream();
        File outFile = new File(tempDir, fileName);
        FileOutputStream os = new FileOutputStream(outFile, false);
        byte[] buf = new byte[400];
        int size = 0;
        while (size != -1)
        {
            size = is.read(buf);
            if (size > 0) {
                os.write(buf, 0, size);
            }
        }
        is.close();
        os.close();
        return outFile.toURI();
    }
}
