/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.soap.ws;

import java.io.File;
import java.net.URL;

import org.jboss.aop.joinpoint.MethodInvocation;

/**
 * Aspect used to handle basic class to jar file conversion for vfszip.
 * 
 * @author <a href='mailto:Kevin.Conner@jboss.com'>Kevin Conner</a>
 */
public class CompilerAspect
{
    public Object getJarFile(final MethodInvocation invocation)
        throws Throwable
    {
        final Object[] args = invocation.getArguments() ;
        final Class<?> targetClass = (Class<?>)args[0] ;
        
        final String resourceName = '/' + targetClass.getName().replace('.', '/') + ".class" ;
        final URL url = targetClass.getResource(resourceName) ;
        if (url != null)
        {
            if ("vfszip".equals(url.getProtocol()))
            {
                final String path = url.getPath() ;
                if (path.endsWith(resourceName))
                {
                    final String realPath = path.substring(0, path.length() - resourceName.length()) ;
                    return new File(realPath) ;
                }
            }
        }
        return invocation.invokeNext() ;
    }
}
