/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.esb.server.routing;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.PrintWriter;

import org.apache.log4j.Logger;

/**
 * A Servlet that echos the input request's body.
 *
 * @author <a href="mailto:mageshbk@jboss.com">Magesh Kumar B</a>
 */
public class EchoServlet extends HttpServlet
{
    private Logger log = Logger.getLogger(EchoServlet.class);

    public void init(ServletConfig config) throws ServletException
    {
        super.init(config);
        log.info("EchoServlet initialized!");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {
        PrintWriter pw = new PrintWriter (response.getOutputStream());
        BufferedReader reader = new BufferedReader(new InputStreamReader(request.getInputStream()));
        String line = reader.readLine();
        while (line != null)
        {
            pw.println(line);
            line = reader.readLine();
        }
        reader.close();
        pw.flush();
        pw.close();
    }
}
