package org.jboss.soa.esb.quickstart.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import junit.framework.Test;
import junit.framework.TestCase;

public class CamelHelloWorldTest extends AbstractQuickstartTestCase {
	private static final String TEST_STRING = "TEST_STRING";
	
	public CamelHelloWorldTest(String name) {
		super(name);
	}

	public void testCamel() throws IOException {
		String buildDir = Helpers.getQuickstartLocation("camel_helloworld/build");
		File file = new File(buildDir + File.separator + "input.txt");
		writeDataToFile(file, TEST_STRING.getBytes());
		
		try {
		Thread.sleep(5000);
		} catch (Exception e) {e.printStackTrace();}
	}
	
    /**
     * Write the supplied data to the specified file.
     * @param file File to write to.
     * @param data Data to be written.
     */
    public static void writeDataToFile(File file, byte[] data) {
        FileOutputStream fileStream = null;

        try {
        	fileStream = new FileOutputStream(file);
            fileStream.write(data);
        } catch (IOException e) {
        	String errorMsg = "Error writing to file: " + file.getAbsolutePath();
            TestCase.fail(errorMsg);
        } finally {
        	if(fileStream != null) {
            	try {
                	fileStream.flush();
                    fileStream.close();
                } catch (IOException e) {
                }
        	}
        }
    }
	
	public static Test suite() throws Exception {
		return getDeploySetup(CamelHelloWorldTest.class, "QuickstartMessageStoreServer.sar, Quickstart_camel_helloworld.esb");
	}
}
