/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.bpel.clustering;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.soa.bpel.runtime.engine.ode.BPELEngineImpl;
import org.jboss.util.naming.NonSerializableFactory;

/**
 * @author Jeff Yu
 *
 */
public class JBossClusteringService implements ClusteringService{
	
	private static final Log logger = LogFactory.getLog(JBossClusteringService.class);
	
	private HAPartition haPartition;
	
	private String bpelEngineName; 
	
	private ODEJobClusterListener listener;
	
	private BPELEngineImpl engine;
	
	public void start() {
		engine = getBpelEngine();
		listener = new ODEJobClusterListener(engine.getScheduler(), engine.getSchedulerDAOConnectionFactory(), engine.getTransactionManager());
		this.haPartition.registerMembershipListener(listener);
		logger.debug("Registered ODEJobCluster Listener.");
		
	}
	
	public String getMasterNodeId() {
		if (!haPartition.getCurrentView().isEmpty()) {
			String nodeId = haPartition.getCurrentView().elementAt(0).toString();
			logger.debug("The master node id is: " + nodeId);
			return nodeId;
		}
		throw new ClusteringException("There are no nodes available in this clustering environment");
	}
	
	public void stop() {
		if (listener != null) {
			this.haPartition.unregisterMembershipListener(listener);
			logger.debug("Unregistered ODEJobCluster Listener.");
		}
	}
	
	
	public HAPartition getHaPartition() {
		return haPartition;
	}

	public void setHaPartition(HAPartition haPartition) {
		this.haPartition = haPartition;
	}

	public String getBpelEngineName() {
		return bpelEngineName;
	}

	public void setBpelEngineName(String bpelEngineName) {
		this.bpelEngineName = bpelEngineName;
	}
	
	public BPELEngineImpl getBpelEngine() {		
		BPELEngineImpl engine = (BPELEngineImpl)NonSerializableFactory.lookup(this.bpelEngineName);		
		return engine;
	}


}
