/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantLong;

public class UnnecessaryMath
extends BytecodeScanningDetector
implements StatelessDetector {
    static final int SEEN_NOTHING = 0;
    static final int SEEN_DCONST = 1;
    private BugReporter bugReporter;
    private int state = 0;
    private double constValue;
    private static final Set<String> zeroMethods = new HashSet<String>(){
        {
            this.add("acos");
            this.add("asin");
            this.add("atan");
            this.add("atan2");
            this.add("cbrt");
            this.add("cos");
            this.add("cosh");
            this.add("exp");
            this.add("expm1");
            this.add("log");
            this.add("log10");
            this.add("pow");
            this.add("sin");
            this.add("sinh");
            this.add("sqrt");
            this.add("tan");
            this.add("tanh");
            this.add("toDegrees");
            this.add("toRadians");
        }
    };
    private static final Set<String> oneMethods = new HashSet<String>(){
        {
            this.add("acos");
            this.add("asin");
            this.add("atan");
            this.add("cbrt");
            this.add("exp");
            this.add("log");
            this.add("log10");
            this.add("pow");
            this.add("sqrt");
            this.add("toDegrees");
        }
    };
    private static final Set<String> anyMethods = new HashSet<String>(){
        {
            this.add("abs");
            this.add("ceil");
            this.add("floor");
            this.add("rint");
            this.add("round");
        }
    };

    public UnnecessaryMath(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code obj) {
        if (this.getMethod().getName().equals("<clinit>")) {
            return;
        }
        this.state = 0;
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        if (this.state == 0) {
            if (seen == 14 || seen == 15) {
                this.constValue = seen - 14;
                this.state = 1;
            } else if (seen == 20 || seen == 19) {
                this.state = 1;
                Constant c = this.getConstantRefOperand();
                if (c instanceof ConstantDouble) {
                    this.constValue = ((ConstantDouble)c).getBytes();
                } else if (c instanceof ConstantFloat) {
                    this.constValue = ((ConstantFloat)c).getBytes();
                } else if (c instanceof ConstantLong) {
                    this.constValue = ((ConstantLong)c).getBytes();
                } else {
                    this.state = 0;
                }
            }
        } else if (this.state == 1) {
            if (seen == 184) {
                this.state = 0;
                if (this.getDottedClassConstantOperand().equals("java.lang.Math")) {
                    String methodName = this.getNameConstantOperand();
                    if (this.constValue == 0.0 && zeroMethods.contains(methodName) || this.constValue == 1.0 && oneMethods.contains(methodName) || anyMethods.contains(methodName)) {
                        this.bugReporter.reportBug(new BugInstance("UM_UNNECESSARY_MATH", 3).addClassAndMethod(this).addSourceLine(this));
                    }
                }
            }
            this.state = 0;
        }
    }
}

