/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.listener.mina;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.IODataConnectionFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.FtpServerSession;
import org.apache.ftpserver.interfaces.Ssl;
import org.apache.ftpserver.listener.AbstractConnection;
import org.apache.ftpserver.listener.ConnectionObserver;
import org.apache.ftpserver.listener.mina.MinaListener;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.SSLFilter;

public class MinaConnection
extends AbstractConnection {
    private IoSession session;

    public MinaConnection(FtpServerContext serverContext, IoSession session, MinaListener listener) throws IOException {
        super(serverContext);
        SSLFilter sslFilter;
        SSLSession sslSession;
        this.session = session;
        this.ftpSession = new FtpSessionImpl(serverContext);
        this.ftpSession.setClientAddress(((InetSocketAddress)session.getRemoteAddress()).getAddress());
        this.ftpSession.setServerAddress(((InetSocketAddress)session.getLocalAddress()).getAddress());
        this.ftpSession.setServerPort(((InetSocketAddress)session.getLocalAddress()).getPort());
        this.ftpSession.setListener(listener);
        IODataConnectionFactory dataCon = new IODataConnectionFactory(this.serverContext, this.ftpSession);
        dataCon.setServerControlAddress(((InetSocketAddress)session.getLocalAddress()).getAddress());
        this.ftpSession.setFtpDataConnection(dataCon);
        if (session.getFilterChain().contains("sslFilter") && (sslSession = (sslFilter = (SSLFilter)session.getFilterChain().get("sslFilter")).getSSLSession(session)) != null) {
            try {
                this.ftpSession.setClientCertificates(sslFilter.getSSLSession(session).getPeerCertificates());
            }
            catch (SSLPeerUnverifiedException e) {
                // empty catch block
            }
        }
    }

    public void setObserver(ConnectionObserver observer) {
        this.session.setAttribute("observer", (Object)observer);
    }

    public void close() {
        this.session.close().join();
    }

    public void beforeSecureControlChannel(FtpServerSession ftpSession, String type) throws Exception {
        Ssl ssl = ftpSession.getListener().getSsl();
        if (ssl == null) {
            throw new FtpException("Socket factory SSL not configured");
        }
        this.session.setAttribute(SSLFilter.DISABLE_ENCRYPTION_ONCE);
        SSLFilter sslFilter = new SSLFilter(ssl.getSSLContext());
        sslFilter.setNeedClientAuth(ssl.getClientAuthenticationRequired());
        this.session.getFilterChain().addFirst("sslSessionFilter", (IoFilter)sslFilter);
    }

    public void afterSecureControlChannel(FtpServerSession ftpSession, String type) throws Exception {
    }
}

