/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.CommonSOAPFaultException;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.extensions.security.EncodingOperation;
import org.jboss.ws.extensions.security.EncryptionOperation;
import org.jboss.ws.extensions.security.InvalidSecurityHeaderException;
import org.jboss.ws.extensions.security.OperationDescription;
import org.jboss.ws.extensions.security.QNameTarget;
import org.jboss.ws.extensions.security.RequireEncryptionOperation;
import org.jboss.ws.extensions.security.RequireOperation;
import org.jboss.ws.extensions.security.RequireSignatureOperation;
import org.jboss.ws.extensions.security.RequireTimestampOperation;
import org.jboss.ws.extensions.security.SecurityDecoder;
import org.jboss.ws.extensions.security.SecurityEncoder;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.SendUsernameOperation;
import org.jboss.ws.extensions.security.SignatureOperation;
import org.jboss.ws.extensions.security.Target;
import org.jboss.ws.extensions.security.TimestampOperation;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.WSSecurityException;
import org.jboss.ws.extensions.security.WsuIdTarget;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.wsse.Config;
import org.jboss.ws.metadata.wsse.Encrypt;
import org.jboss.ws.metadata.wsse.Operation;
import org.jboss.ws.metadata.wsse.Port;
import org.jboss.ws.metadata.wsse.RequireEncryption;
import org.jboss.ws.metadata.wsse.RequireSignature;
import org.jboss.ws.metadata.wsse.RequireTimestamp;
import org.jboss.ws.metadata.wsse.Requires;
import org.jboss.ws.metadata.wsse.Sign;
import org.jboss.ws.metadata.wsse.Timestamp;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.wsf.common.DOMWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSecurityDispatcher {
    private static Logger log = Logger.getLogger(WSSecurityDispatcher.class);

    private static List<Target> convertTargets(List<org.jboss.ws.metadata.wsse.Target> targets) {
        if (targets == null) {
            return null;
        }
        ArrayList<Target> newList = new ArrayList<Target>(targets.size());
        for (org.jboss.ws.metadata.wsse.Target target : targets) {
            if ("qname".equals(target.getType())) {
                QNameTarget qnameTarget = new QNameTarget(QName.valueOf(target.getValue()), target.isContentOnly());
                newList.add(qnameTarget);
                continue;
            }
            if (!"wsuid".equals(target.getType())) continue;
            newList.add(new WsuIdTarget(target.getValue()));
        }
        return newList;
    }

    private static Config getConfig(WSSecurityConfiguration config, String portName, String operationName) {
        Port port = config.getPorts().get(portName);
        if (port == null) {
            return config.getDefaultConfig();
        }
        Operation operation = port.getOperations().get(operationName);
        if (operation == null) {
            Config portConfig = port.getDefaultConfig();
            return portConfig == null ? config.getDefaultConfig() : portConfig;
        }
        return operation.getConfig();
    }

    private static CommonSOAPFaultException convertToFault(WSSecurityException e) {
        return new CommonSOAPFaultException(e.getFaultCode(), e.getFaultString());
    }

    public static void handleInbound(CommonMessageContext ctx) throws SOAPException, SOAPFaultException {
        QName secQName;
        WSSecurityConfiguration config = WSSecurityDispatcher.getSecurityConfig(ctx);
        SOAPMessageImpl soapMessage = (SOAPMessageImpl)ctx.getSOAPMessage();
        SOAPHeader soapHeader = soapMessage.getSOAPHeader();
        Element secHeaderElement = Util.findElement((Element)soapHeader, secQName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));
        if (secHeaderElement == null) {
            String port;
            String operation;
            if (soapMessage.getSOAPBody().getFault() != null) {
                return;
            }
            OperationMetaData opMetaData = ctx.getOperationMetaData();
            if (opMetaData == null) {
                EndpointMetaData epMetaData = ctx.getEndpointMetaData();
                opMetaData = soapMessage.getOperationMetaData(epMetaData);
            }
            if (WSSecurityDispatcher.hasRequirements(config, operation = opMetaData.getQName().toString(), port = opMetaData.getEndpointMetaData().getPortName().getLocalPart())) {
                throw WSSecurityDispatcher.convertToFault(new InvalidSecurityHeaderException("This service requires <wsse:Security>, which is missing."));
            }
            return;
        }
        try {
            OperationMetaData opMetaData;
            SecurityStore securityStore = new SecurityStore(config.getKeyStoreURL(), config.getKeyStoreType(), config.getKeyStorePassword(), config.getKeyPasswords(), config.getTrustStoreURL(), config.getTrustStoreType(), config.getTrustStorePassword());
            SecurityDecoder decoder = new SecurityDecoder(securityStore);
            decoder.decode((Document)soapMessage.getSOAPPart(), secHeaderElement);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Decoded Message:\n" + DOMWriter.printNode((Node)soapMessage.getSOAPPart(), true)));
            }
            if ((opMetaData = ctx.getOperationMetaData()) == null) {
                EndpointMetaData epMetaData = ctx.getEndpointMetaData();
                opMetaData = soapMessage.getOperationMetaData(epMetaData);
            }
            String operation = opMetaData.getQName().toString();
            String port = opMetaData.getEndpointMetaData().getPortName().getLocalPart();
            List<OperationDescription<RequireOperation>> operations = WSSecurityDispatcher.buildRequireOperations(config, operation, port);
            decoder.verify(operations);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Verification is successful");
            }
            decoder.complete();
        }
        catch (WSSecurityException e) {
            if (e.isInternalError()) {
                log.error((Object)"Internal error occured handling inbound message:", (Throwable)e);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Returning error to sender: " + e.getMessage()));
            }
            throw WSSecurityDispatcher.convertToFault(e);
        }
    }

    private static WSSecurityConfiguration getSecurityConfig(CommonMessageContext ctx) {
        WSSecurityConfiguration config = ctx.getEndpointMetaData().getServiceMetaData().getSecurityConfiguration();
        if (config == null) {
            throw new WSException("Cannot obtain security configuration from message context");
        }
        return config;
    }

    private static boolean hasRequirements(WSSecurityConfiguration config, String operation, String port) {
        Config operationConfig = WSSecurityDispatcher.getConfig(config, port, operation);
        return operationConfig != null && operationConfig.getRequires() != null;
    }

    private static List<OperationDescription<RequireOperation>> buildRequireOperations(WSSecurityConfiguration config, String operation, String port) {
        RequireEncryption requireEncryption;
        RequireSignature requireSignature;
        Config operationConfig = WSSecurityDispatcher.getConfig(config, port, operation);
        if (operationConfig == null) {
            return null;
        }
        Requires requires = operationConfig.getRequires();
        if (requires == null) {
            return null;
        }
        ArrayList<OperationDescription<RequireOperation>> operations = new ArrayList<OperationDescription<RequireOperation>>();
        RequireTimestamp requireTimestamp = requires.getRequireTimestamp();
        if (requireTimestamp != null) {
            operations.add(new OperationDescription<RequireTimestampOperation>(RequireTimestampOperation.class, null, requireTimestamp.getMaxAge(), null, null));
        }
        if ((requireSignature = requires.getRequireSignature()) != null) {
            List<Target> targets = WSSecurityDispatcher.convertTargets(requireSignature.getTargets());
            operations.add(new OperationDescription<RequireSignatureOperation>(RequireSignatureOperation.class, targets, null, null, null));
        }
        if ((requireEncryption = requires.getRequireEncryption()) != null) {
            List<Target> targets = WSSecurityDispatcher.convertTargets(requireEncryption.getTargets());
            operations.add(new OperationDescription<RequireEncryptionOperation>(RequireEncryptionOperation.class, targets, null, null, null));
        }
        return operations;
    }

    public static void handleOutbound(CommonMessageContext ctx) throws SOAPException, SOAPFaultException {
        Encrypt encrypt;
        Sign sign;
        WSSecurityConfiguration config = WSSecurityDispatcher.getSecurityConfig(ctx);
        SOAPMessageImpl soapMessage = (SOAPMessageImpl)ctx.getSOAPMessage();
        OperationMetaData opMetaData = ctx.getOperationMetaData();
        String operation = opMetaData.getQName().toString();
        String port = opMetaData.getEndpointMetaData().getPortName().getLocalPart();
        Config operationConfig = WSSecurityDispatcher.getConfig(config, port, operation);
        log.debug((Object)("WS-Security config: " + operationConfig));
        if (operationConfig == null) {
            return;
        }
        ArrayList<OperationDescription<EncodingOperation>> operations = new ArrayList<OperationDescription<EncodingOperation>>();
        Timestamp timestamp = operationConfig.getTimestamp();
        if (timestamp != null) {
            operations.add(new OperationDescription<TimestampOperation>(TimestampOperation.class, null, null, timestamp.getTtl(), null));
        }
        if (operationConfig.getUsername() != null) {
            Object user = ctx.get("javax.xml.rpc.security.auth.username");
            Object pass = ctx.get("javax.xml.rpc.security.auth.password");
            if (user == null && pass == null) {
                user = ctx.get("javax.xml.ws.security.auth.username");
                pass = ctx.get("javax.xml.ws.security.auth.password");
            }
            if (user != null && pass != null) {
                operations.add(new OperationDescription<SendUsernameOperation>(SendUsernameOperation.class, null, user.toString(), pass.toString(), null));
                ctx.put("org.jboss.ws.authType", (Object)"org.jboss.ws.authType.wsse");
            }
        }
        if ((sign = operationConfig.getSign()) != null) {
            List<Target> targets = WSSecurityDispatcher.convertTargets(sign.getTargets());
            if (sign.isIncludeTimestamp()) {
                if (timestamp == null) {
                    operations.add(new OperationDescription<TimestampOperation>(TimestampOperation.class, null, null, null, null));
                }
                if (targets != null && targets.size() > 0) {
                    targets.add(new WsuIdTarget("timestamp"));
                }
            }
            operations.add(new OperationDescription<SignatureOperation>(SignatureOperation.class, targets, sign.getAlias(), null, null));
        }
        if ((encrypt = operationConfig.getEncrypt()) != null) {
            List<Target> targets = WSSecurityDispatcher.convertTargets(encrypt.getTargets());
            operations.add(new OperationDescription<EncryptionOperation>(EncryptionOperation.class, targets, encrypt.getAlias(), null, encrypt.getAlgorithm()));
        }
        if (operations.size() == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Encoding Message:\n" + DOMWriter.printNode((Node)soapMessage.getSOAPPart(), true)));
        }
        try {
            SecurityStore securityStore = new SecurityStore(config.getKeyStoreURL(), config.getKeyStoreType(), config.getKeyStorePassword(), config.getKeyPasswords(), config.getTrustStoreURL(), config.getTrustStoreType(), config.getTrustStorePassword());
            SecurityEncoder encoder = new SecurityEncoder(operations, securityStore);
            encoder.encode((Document)soapMessage.getSOAPPart());
        }
        catch (WSSecurityException e) {
            if (e.isInternalError()) {
                log.error((Object)"Internal error occured handling outbound message:", (Throwable)e);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Returning error to sender: " + e.getMessage()));
            }
            throw WSSecurityDispatcher.convertToFault(e);
        }
    }
}

