/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap.attachment;

import java.util.Arrays;

public class SimpleBoyerMoore {
    private int[] badMatch = new int[256];
    private byte[] pattern;
    public static final int PATTERN_NOT_FOUND = -1;

    public SimpleBoyerMoore(byte[] pattern) {
        this.pattern = pattern;
        this.precomputeBadMatchTable();
    }

    private void precomputeBadMatchTable() {
        Arrays.fill(this.badMatch, this.pattern.length);
        for (int i = 0; i < this.pattern.length - 1; ++i) {
            this.badMatch[this.pattern[i] & 0xFF] = this.pattern.length - i - 1;
        }
    }

    public int patternSearch(byte[] text, int offset, int length) {
        if (this.pattern.length > length) {
            return -1;
        }
        int i = 0;
        int j = 0;
        int k = 0;
        int end = offset + length;
        for (i = offset + this.pattern.length - 1; i < end; i += this.badMatch[text[i] & 0xFF]) {
            k = i;
            for (j = this.pattern.length - 1; j >= 0 && text[k] == this.pattern[j]; --j) {
                --k;
            }
            if (j != -1) continue;
            return k + 1;
        }
        return -1;
    }
}

