/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.CallContextCache;
import com.kenai.jffi.Platform;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.util.Map;
import jnr.ffi.Address;
import jnr.ffi.CallingConvention;
import jnr.ffi.LibraryOption;
import jnr.ffi.NativeLong;
import jnr.ffi.NativeType;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.Type;
import jnr.ffi.annotations.IgnoreError;
import jnr.ffi.annotations.LongLong;
import jnr.ffi.annotations.SaveError;
import jnr.ffi.annotations.StdCall;
import jnr.ffi.annotations.TypeDefinition;
import jnr.ffi.byref.ByReference;
import jnr.ffi.mapper.FromNativeConverter;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.provider.jffi.AsmUtil;
import jnr.ffi.provider.jffi.NativeRuntime;
import jnr.ffi.provider.jffi.ParameterType;
import jnr.ffi.provider.jffi.ResultType;
import jnr.ffi.provider.jffi.SigType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InvokerUtil {
    InvokerUtil() {
    }

    static NativeType getAliasedNativeType(NativeRuntime runtime, Class type2, Annotation[] annotations2) {
        for (Annotation a : annotations2) {
            TypeDefinition typedef = a.annotationType().getAnnotation(TypeDefinition.class);
            if (typedef == null) continue;
            return InvokerUtil.nativeType(runtime.findType(typedef.alias()));
        }
        if (InvokerUtil.isLong32(type2, annotations2)) {
            return NativeType.SLONG;
        }
        if (InvokerUtil.isLongLong(type2, annotations2)) {
            return NativeType.SLONGLONG;
        }
        return null;
    }

    public static final boolean requiresErrno(Method method2) {
        boolean saveError = true;
        for (Annotation a : method2.getAnnotations()) {
            if (a instanceof IgnoreError) {
                saveError = false;
                continue;
            }
            if (!(a instanceof SaveError)) continue;
            saveError = true;
        }
        return saveError;
    }

    public static com.kenai.jffi.CallingConvention getCallingConvention(Map<LibraryOption, ?> libraryOptions) {
        Object convention = libraryOptions.get((Object)LibraryOption.CallingConvention);
        if (convention instanceof com.kenai.jffi.CallingConvention) {
            return (com.kenai.jffi.CallingConvention)((Object)convention);
        }
        if (convention instanceof CallingConvention) {
            switch ((CallingConvention)((Object)convention)) {
                case DEFAULT: {
                    return com.kenai.jffi.CallingConvention.DEFAULT;
                }
                case STDCALL: {
                    return com.kenai.jffi.CallingConvention.STDCALL;
                }
            }
        } else if (convention != null) {
            throw new IllegalArgumentException("unknown calling convention: " + convention);
        }
        return com.kenai.jffi.CallingConvention.DEFAULT;
    }

    public static boolean hasAnnotation(Annotation[] annotations2, Class<? extends Annotation> annotationClass) {
        for (Annotation a : annotations2) {
            if (!annotationClass.isInstance(a)) continue;
            return true;
        }
        return false;
    }

    static boolean isLong32(Class type2, Annotation[] annotations2) {
        return (Long.TYPE == type2 || Long.class.isAssignableFrom(type2)) && Platform.getPlatform().longSize() == 32 && !InvokerUtil.hasAnnotation(annotations2, LongLong.class);
    }

    static boolean isLongLong(Class type2, Annotation[] annotations2) {
        return !(Long.TYPE != type2 && !Long.class.isAssignableFrom(type2) || !InvokerUtil.hasAnnotation(annotations2, LongLong.class) && Platform.getPlatform().longSize() != 64);
    }

    static com.kenai.jffi.Type jffiType(NativeType jnrType) {
        switch (jnrType) {
            case VOID: {
                return com.kenai.jffi.Type.VOID;
            }
            case SCHAR: {
                return com.kenai.jffi.Type.SCHAR;
            }
            case UCHAR: {
                return com.kenai.jffi.Type.UCHAR;
            }
            case SSHORT: {
                return com.kenai.jffi.Type.SSHORT;
            }
            case USHORT: {
                return com.kenai.jffi.Type.USHORT;
            }
            case SINT: {
                return com.kenai.jffi.Type.SINT;
            }
            case UINT: {
                return com.kenai.jffi.Type.UINT;
            }
            case SLONG: {
                return com.kenai.jffi.Type.SLONG;
            }
            case ULONG: {
                return com.kenai.jffi.Type.ULONG;
            }
            case SLONGLONG: {
                return com.kenai.jffi.Type.SLONG_LONG;
            }
            case ULONGLONG: {
                return com.kenai.jffi.Type.ULONG_LONG;
            }
            case FLOAT: {
                return com.kenai.jffi.Type.FLOAT;
            }
            case DOUBLE: {
                return com.kenai.jffi.Type.DOUBLE;
            }
            case ADDRESS: {
                return com.kenai.jffi.Type.POINTER;
            }
        }
        throw new IllegalArgumentException("unsupported parameter type: " + (Object)((Object)jnrType));
    }

    static NativeType nativeType(Type jnrType) {
        return jnrType.getNativeType();
    }

    static ResultType getResultType(NativeRuntime runtime, Class type2, Annotation[] annotations2, FromNativeConverter fromNativeConverter) {
        NativeType nativeType = InvokerUtil.getMethodResultNativeType(runtime, fromNativeConverter != null ? fromNativeConverter.nativeType() : type2, annotations2);
        return new ResultType(type2, nativeType, annotations2, fromNativeConverter);
    }

    static ParameterType getParameterType(NativeRuntime runtime, Class type2, Annotation[] annotations2, ToNativeConverter toNativeConverter) {
        NativeType nativeType = InvokerUtil.getMethodParameterNativeType(runtime, toNativeConverter != null ? toNativeConverter.nativeType() : type2, annotations2);
        return new ParameterType(type2, nativeType, annotations2, toNativeConverter);
    }

    static CallContext getCallContext(SigType resultType, SigType[] parameterTypes, com.kenai.jffi.CallingConvention convention, boolean requiresErrno) {
        com.kenai.jffi.Type[] nativeParamTypes = new com.kenai.jffi.Type[parameterTypes.length];
        for (int i2 = 0; i2 < nativeParamTypes.length; ++i2) {
            nativeParamTypes[i2] = InvokerUtil.jffiType(parameterTypes[i2].nativeType);
        }
        return CallContextCache.getInstance().getCallContext(InvokerUtil.jffiType(resultType.nativeType), nativeParamTypes, convention, requiresErrno);
    }

    static CallContext getCallContext(NativeType resultType, NativeType[] parameterTypes, com.kenai.jffi.CallingConvention convention, boolean requiresErrno) {
        com.kenai.jffi.Type[] nativeParamTypes = new com.kenai.jffi.Type[parameterTypes.length];
        for (int i2 = 0; i2 < nativeParamTypes.length; ++i2) {
            nativeParamTypes[i2] = InvokerUtil.jffiType(parameterTypes[i2]);
        }
        return CallContextCache.getInstance().getCallContext(InvokerUtil.jffiType(resultType), nativeParamTypes, convention, requiresErrno);
    }

    public static com.kenai.jffi.CallingConvention getNativeCallingConvention(Method m) {
        if (m.getAnnotation(StdCall.class) != null || m.getDeclaringClass().getAnnotation(StdCall.class) != null) {
            return com.kenai.jffi.CallingConvention.STDCALL;
        }
        return com.kenai.jffi.CallingConvention.DEFAULT;
    }

    static NativeType getNativeType(NativeRuntime runtime, Class type2, Annotation[] annotations2) {
        NativeType aliasedType = InvokerUtil.getAliasedNativeType(runtime, type2, annotations2);
        if (aliasedType != null) {
            return aliasedType;
        }
        if (Void.class.isAssignableFrom(type2) || Void.TYPE == type2) {
            return NativeType.VOID;
        }
        if (Boolean.class.isAssignableFrom(type2) || Boolean.TYPE == type2) {
            return NativeType.SINT;
        }
        if (Byte.class.isAssignableFrom(type2) || Byte.TYPE == type2) {
            return NativeType.SCHAR;
        }
        if (Short.class.isAssignableFrom(type2) || Short.TYPE == type2) {
            return NativeType.SSHORT;
        }
        if (Integer.class.isAssignableFrom(type2) || Integer.TYPE == type2) {
            return NativeType.SINT;
        }
        if (Long.class.isAssignableFrom(type2) || Long.TYPE == type2) {
            return InvokerUtil.isLongLong(type2, annotations2) ? NativeType.SLONGLONG : NativeType.SLONG;
        }
        if (NativeLong.class.isAssignableFrom(type2)) {
            return NativeType.SLONG;
        }
        if (Float.class.isAssignableFrom(type2) || Float.TYPE == type2) {
            return NativeType.FLOAT;
        }
        if (Double.class.isAssignableFrom(type2) || Double.TYPE == type2) {
            return NativeType.DOUBLE;
        }
        if (Pointer.class.isAssignableFrom(type2)) {
            return NativeType.ADDRESS;
        }
        if (Address.class.isAssignableFrom(type2)) {
            return NativeType.ADDRESS;
        }
        if (Struct.class.isAssignableFrom(type2)) {
            return NativeType.ADDRESS;
        }
        if (String.class.isAssignableFrom(type2)) {
            return NativeType.ADDRESS;
        }
        if (Buffer.class.isAssignableFrom(type2)) {
            return NativeType.ADDRESS;
        }
        if (CharSequence.class.isAssignableFrom(type2)) {
            return NativeType.ADDRESS;
        }
        if (ByReference.class.isAssignableFrom(type2)) {
            return NativeType.ADDRESS;
        }
        if (type2.isArray()) {
            return NativeType.ADDRESS;
        }
        if (AsmUtil.isDelegate(type2)) {
            return NativeType.ADDRESS;
        }
        throw new IllegalArgumentException("unsupported type: " + type2);
    }

    static NativeType getMethodParameterNativeType(NativeRuntime runtime, Class parameterClass, Annotation[] annotations2) {
        return InvokerUtil.getNativeType(runtime, parameterClass, annotations2);
    }

    static NativeType getMethodResultNativeType(NativeRuntime runtime, Class parameterClass, Annotation[] annotations2) {
        return InvokerUtil.getNativeType(runtime, parameterClass, annotations2);
    }
}

