/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.WhenNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseNode
extends Node {
    private final Node caseNode;
    private final ListNode cases;
    private Node elseNode = null;

    public CaseNode(ISourcePosition position, Node caseNode, ListNode cases) {
        super(position);
        assert (cases != null) : "caseBody is not null";
        this.caseNode = caseNode;
        this.cases = cases;
    }

    public void setElseNode(Node elseNode) {
        this.elseNode = elseNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CASENODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitCaseNode(this);
    }

    public Node getCaseNode() {
        return this.caseNode;
    }

    public ListNode getCases() {
        return this.cases;
    }

    public Node getElseNode() {
        return this.elseNode;
    }

    @Deprecated
    public Node getFirstWhenNode() {
        return this.cases;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.caseNode, this.cases);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject expression = this.caseNode == null ? null : this.caseNode.interpret(runtime, context, self, aBlock);
        context.pollThreadEvents();
        for (Node child : this.cases.childNodes()) {
            IRubyObject result2;
            WhenNode when = (WhenNode)child;
            ISourcePosition position = child.getPosition();
            context.setFileAndLine(position.getFile(), position.getStartLine());
            if (runtime.hasEventHooks()) {
                ASTInterpreter.callTraceFunction(runtime, context, RubyEvent.LINE);
            }
            if ((result2 = when.when(expression, context, runtime, self, aBlock)) != null) {
                return result2;
            }
            context.pollThreadEvents();
        }
        return this.elseNode != null ? this.elseNode.interpret(runtime, context, self, aBlock) : runtime.getNil();
    }
}

