/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;

public class EVP {
    public static Cipher getCipher(DERObjectIdentifier oid2) throws GeneralSecurityException {
        String algorithm = EVP.getAlgorithmName(oid2);
        String[] cipher2 = Cipher.Algorithm.osslToJsse(algorithm);
        String realName = cipher2[3];
        return Cipher.getInstance(realName);
    }

    public static Cipher getCipher(int nid) throws GeneralSecurityException {
        return EVP.getCipher(ASN1Registry.nid2obj(nid));
    }

    public static MessageDigest getDigest(DERObjectIdentifier oid2) throws GeneralSecurityException {
        String algorithm = EVP.getAlgorithmName(oid2);
        return MessageDigest.getInstance(algorithm);
    }

    public static MessageDigest getDigest(int nid) throws GeneralSecurityException {
        return EVP.getDigest(ASN1Registry.nid2obj(nid));
    }

    public static MessageDigest sha1() {
        try {
            return MessageDigest.getInstance("SHA1");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int type(MessageDigest digest2) {
        String name2 = digest2.getAlgorithm();
        DERObjectIdentifier obj = ASN1Registry.sym2oid(name2);
        if (obj == null) {
            name2 = name2.toLowerCase().replace("sha-", "sha");
            obj = ASN1Registry.sym2oid(name2);
        }
        return ASN1Registry.obj2nid(obj);
    }

    public static String signatureAlgorithm(MessageDigest digest2, Key key2) {
        String sig = digest2.getAlgorithm().toLowerCase().replace("sha-", "sha");
        String type2 = key2.getAlgorithm().toLowerCase();
        if (sig == null) {
            sig = "none";
        }
        return sig + "with" + type2;
    }

    public static byte[] decrypt(byte[] input, int offset2, int len, Key key2) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher2 = Cipher.getInstance(key2.getAlgorithm());
        cipher2.init(2, key2);
        return cipher2.doFinal(input, offset2, len);
    }

    public static byte[] decrypt(byte[] input, Key key2) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        return EVP.decrypt(input, 0, input.length, key2);
    }

    private static String getAlgorithmName(DERObjectIdentifier oid2) {
        String algorithm = ASN1Registry.o2a(oid2);
        if (algorithm != null) {
            return algorithm.toUpperCase();
        }
        return oid2.getId();
    }
}

