/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BranchInstr
extends Instr {
    private Label target;
    private Operand arg1;
    private Operand arg2;

    public BranchInstr(Operation op, Operand v1, Operand v2, Label jumpTarget) {
        super(op);
        this.target = jumpTarget;
        this.arg1 = v1;
        this.arg2 = v2;
    }

    @Override
    public Operand[] getOperands() {
        Operand[] operandArray;
        if (this.arg2 == null) {
            Operand[] operandArray2 = new Operand[1];
            operandArray = operandArray2;
            operandArray2[0] = this.arg1;
        } else {
            Operand[] operandArray3 = new Operand[2];
            operandArray3[0] = this.arg1;
            operandArray = operandArray3;
            operandArray3[1] = this.arg2;
        }
        return operandArray;
    }

    public Operand getArg1() {
        return this.arg1;
    }

    public Operand getArg2() {
        return this.arg2;
    }

    public Label getJumpTarget() {
        return this.target;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.arg1 = this.arg1.getSimplifiedOperand(valueMap, force);
        if (this.arg2 != null) {
            this.arg2 = this.arg2.getSimplifiedOperand(valueMap, force);
        }
    }

    @Override
    public String toString() {
        return "" + (Object)((Object)this.getOperation()) + "(" + this.arg1 + ", " + (this.arg2 != null ? this.arg2 + ", " : "") + this.target + ")";
    }
}

