/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.math.BigInteger;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.Operand;
import org.jruby.runtime.ThreadContext;

public class Fixnum
extends ImmutableLiteral {
    public final long value;

    public Fixnum(long val) {
        this.value = val;
    }

    public Fixnum(BigInteger val) {
        this(val.longValue());
    }

    public Object createCacheObject(ThreadContext context) {
        return context.runtime.newFixnum(this.value);
    }

    public String toString() {
        return "Fixnum:" + this.value;
    }

    public Operand computeValue(String methodName, Operand arg2) {
        if (arg2 instanceof Fixnum) {
            if (methodName.equals("+")) {
                return new Fixnum(this.value + ((Fixnum)arg2).value);
            }
            if (methodName.equals("-")) {
                return new Fixnum(this.value - ((Fixnum)arg2).value);
            }
            if (methodName.equals("*")) {
                return new Fixnum(this.value * ((Fixnum)arg2).value);
            }
            if (methodName.equals("/")) {
                Long divisor = ((Fixnum)arg2).value;
                return divisor == 0L ? null : new Fixnum(this.value / divisor);
            }
        } else if (arg2 instanceof Float) {
            if (methodName.equals("+")) {
                return new Float((double)this.value + ((Float)arg2).value);
            }
            if (methodName.equals("-")) {
                return new Float((double)this.value - ((Float)arg2).value);
            }
            if (methodName.equals("*")) {
                return new Float((double)this.value * ((Float)arg2).value);
            }
            if (methodName.equals("/")) {
                Double divisor = ((Float)arg2).value;
                return divisor == 0.0 ? null : new Float((double)this.value / divisor);
            }
        }
        return null;
    }

    public void visit(IRVisitor visitor) {
        visitor.Fixnum(this);
    }

    public long getValue() {
        return this.value;
    }
}

