/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.asn1.mozilla;

import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.DERIA5String;
import org.jruby.org.bouncycastle.asn1.DERObject;
import org.jruby.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class PublicKeyAndChallenge
extends ASN1Encodable {
    private ASN1Sequence pkacSeq;
    private SubjectPublicKeyInfo spki;
    private DERIA5String challenge;

    public static PublicKeyAndChallenge getInstance(Object object) {
        if (object instanceof PublicKeyAndChallenge) {
            return (PublicKeyAndChallenge)object;
        }
        if (object instanceof ASN1Sequence) {
            return new PublicKeyAndChallenge((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unkown object in factory: " + object.getClass().getName());
    }

    public PublicKeyAndChallenge(ASN1Sequence aSN1Sequence) {
        this.pkacSeq = aSN1Sequence;
        this.spki = SubjectPublicKeyInfo.getInstance(aSN1Sequence.getObjectAt(0));
        this.challenge = DERIA5String.getInstance(aSN1Sequence.getObjectAt(1));
    }

    public DERObject toASN1Object() {
        return this.pkacSeq;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.spki;
    }

    public DERIA5String getChallenge() {
        return this.challenge;
    }
}

