/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.asn1.tsp;

import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1EncodableVector;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.DERInteger;
import org.jruby.org.bouncycastle.asn1.DERObject;
import org.jruby.org.bouncycastle.asn1.DERSequence;
import org.jruby.org.bouncycastle.asn1.DERTaggedObject;

public class Accuracy
extends ASN1Encodable {
    DERInteger seconds;
    DERInteger millis;
    DERInteger micros;
    protected static final int MIN_MILLIS = 1;
    protected static final int MAX_MILLIS = 999;
    protected static final int MIN_MICROS = 1;
    protected static final int MAX_MICROS = 999;

    protected Accuracy() {
    }

    public Accuracy(DERInteger dERInteger, DERInteger dERInteger2, DERInteger dERInteger3) {
        this.seconds = dERInteger;
        if (dERInteger2 != null && (dERInteger2.getValue().intValue() < 1 || dERInteger2.getValue().intValue() > 999)) {
            throw new IllegalArgumentException("Invalid millis field : not in (1..999)");
        }
        this.millis = dERInteger2;
        if (dERInteger3 != null && (dERInteger3.getValue().intValue() < 1 || dERInteger3.getValue().intValue() > 999)) {
            throw new IllegalArgumentException("Invalid micros field : not in (1..999)");
        }
        this.micros = dERInteger3;
    }

    public Accuracy(ASN1Sequence aSN1Sequence) {
        this.seconds = null;
        this.millis = null;
        this.micros = null;
        block4: for (int j = 0; j < aSN1Sequence.size(); ++j) {
            if (aSN1Sequence.getObjectAt(j) instanceof DERInteger) {
                this.seconds = (DERInteger)aSN1Sequence.getObjectAt(j);
                continue;
            }
            if (!(aSN1Sequence.getObjectAt(j) instanceof DERTaggedObject)) continue;
            DERTaggedObject dERTaggedObject = (DERTaggedObject)aSN1Sequence.getObjectAt(j);
            switch (dERTaggedObject.getTagNo()) {
                case 0: {
                    this.millis = DERInteger.getInstance(dERTaggedObject, false);
                    if (this.millis.getValue().intValue() >= 1 && this.millis.getValue().intValue() <= 999) continue block4;
                    throw new IllegalArgumentException("Invalid millis field : not in (1..999).");
                }
                case 1: {
                    this.micros = DERInteger.getInstance(dERTaggedObject, false);
                    if (this.micros.getValue().intValue() >= 1 && this.micros.getValue().intValue() <= 999) continue block4;
                    throw new IllegalArgumentException("Invalid micros field : not in (1..999).");
                }
                default: {
                    throw new IllegalArgumentException("Invalig tag number");
                }
            }
        }
    }

    public static Accuracy getInstance(Object object) {
        if (object == null || object instanceof Accuracy) {
            return (Accuracy)object;
        }
        if (object instanceof ASN1Sequence) {
            return new Accuracy((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Unknown object in 'Accuracy' factory : " + object.getClass().getName() + ".");
    }

    public DERInteger getSeconds() {
        return this.seconds;
    }

    public DERInteger getMillis() {
        return this.millis;
    }

    public DERInteger getMicros() {
        return this.micros;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.seconds != null) {
            aSN1EncodableVector.add(this.seconds);
        }
        if (this.millis != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.millis));
        }
        if (this.micros != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.micros));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

