/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cms;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEParameterSpec;

public abstract class CMSPBEKey
implements PBEKey {
    private char[] password;
    private byte[] salt;
    private int iterationCount;

    protected static PBEParameterSpec getParamSpec(AlgorithmParameters algorithmParameters) throws InvalidAlgorithmParameterException {
        try {
            return algorithmParameters.getParameterSpec(PBEParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException("cannot process PBE spec: " + invalidParameterSpecException.getMessage());
        }
    }

    public CMSPBEKey(char[] cArray, byte[] byArray, int n) {
        this.password = cArray;
        this.salt = byArray;
        this.iterationCount = n;
    }

    public CMSPBEKey(char[] cArray, PBEParameterSpec pBEParameterSpec) {
        this(cArray, pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
    }

    public char[] getPassword() {
        return this.password;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public String getAlgorithm() {
        return "PKCS5S2";
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        return null;
    }

    abstract byte[] getEncoded(String var1);
}

