/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cms;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import org.jruby.org.bouncycastle.asn1.ASN1EncodableVector;
import org.jruby.org.bouncycastle.asn1.ASN1Object;
import org.jruby.org.bouncycastle.asn1.DERNull;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.DEROctetString;
import org.jruby.org.bouncycastle.asn1.DERSequence;
import org.jruby.org.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import org.jruby.org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.jruby.org.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import org.jruby.org.bouncycastle.asn1.cms.OriginatorPublicKey;
import org.jruby.org.bouncycastle.asn1.cms.RecipientEncryptedKey;
import org.jruby.org.bouncycastle.asn1.cms.RecipientInfo;
import org.jruby.org.bouncycastle.asn1.cms.ecc.MQVuserKeyingMaterial;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.jruby.org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.jruby.org.bouncycastle.cms.CMSEnvelopedHelper;
import org.jruby.org.bouncycastle.cms.CMSUtils;
import org.jruby.org.bouncycastle.cms.IntRecipientInfoGenerator;
import org.jruby.org.bouncycastle.jce.spec.MQVPrivateKeySpec;
import org.jruby.org.bouncycastle.jce.spec.MQVPublicKeySpec;

class KeyAgreeIntRecipientInfoGenerator
implements IntRecipientInfoGenerator {
    private DERObjectIdentifier keyAgreementOID;
    private DERObjectIdentifier keyEncryptionOID;
    private ArrayList recipientCerts;
    private KeyPair senderKeyPair;

    KeyAgreeIntRecipientInfoGenerator() {
    }

    void setKeyAgreementOID(DERObjectIdentifier dERObjectIdentifier) {
        this.keyAgreementOID = dERObjectIdentifier;
    }

    void setKeyEncryptionOID(DERObjectIdentifier dERObjectIdentifier) {
        this.keyEncryptionOID = dERObjectIdentifier;
    }

    void setRecipientCerts(Collection collection) {
        this.recipientCerts = new ArrayList(collection);
    }

    void setSenderKeyPair(KeyPair keyPair) {
        this.senderKeyPair = keyPair;
    }

    public RecipientInfo generate(SecretKey secretKey, SecureRandom secureRandom, Provider provider) throws GeneralSecurityException {
        Object object;
        Object object2;
        Object object3;
        OriginatorIdentifierOrKey originatorIdentifierOrKey;
        PublicKey publicKey = this.senderKeyPair.getPublic();
        PrivateKey privateKey = this.senderKeyPair.getPrivate();
        try {
            originatorIdentifierOrKey = new OriginatorIdentifierOrKey(KeyAgreeIntRecipientInfoGenerator.createOriginatorPublicKey(publicKey));
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("cannot extract originator public key: " + iOException);
        }
        DEROctetString dEROctetString = null;
        if (this.keyAgreementOID.getId().equals(CMSEnvelopedGenerator.ECMQV_SHA1KDF)) {
            try {
                object3 = ((ECPublicKey)publicKey).getParams();
                object2 = KeyPairGenerator.getInstance(this.keyAgreementOID.getId(), provider);
                ((KeyPairGenerator)object2).initialize((AlgorithmParameterSpec)object3, secureRandom);
                object = ((KeyPairGenerator)object2).generateKeyPair();
                dEROctetString = new DEROctetString(new MQVuserKeyingMaterial(KeyAgreeIntRecipientInfoGenerator.createOriginatorPublicKey(((KeyPair)object).getPublic()), null));
                privateKey = new MQVPrivateKeySpec(privateKey, ((KeyPair)object).getPrivate(), ((KeyPair)object).getPublic());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidKeyException("cannot determine MQV ephemeral key pair parameters from public key: " + invalidAlgorithmParameterException);
            }
            catch (IOException iOException) {
                throw new InvalidKeyException("cannot extract MQV ephemeral public key: " + iOException);
            }
        }
        object3 = new ASN1EncodableVector();
        ((ASN1EncodableVector)object3).add(this.keyEncryptionOID);
        ((ASN1EncodableVector)object3).add(DERNull.INSTANCE);
        object2 = new AlgorithmIdentifier(this.keyAgreementOID, new DERSequence((ASN1EncodableVector)object3));
        object = new ASN1EncodableVector();
        for (X509Certificate x509Certificate : this.recipientCerts) {
            KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier = new KeyAgreeRecipientIdentifier(CMSUtils.getIssuerAndSerialNumber(x509Certificate));
            PublicKey publicKey2 = x509Certificate.getPublicKey();
            if (this.keyAgreementOID.getId().equals(CMSEnvelopedGenerator.ECMQV_SHA1KDF)) {
                publicKey2 = new MQVPublicKeySpec(publicKey2, publicKey2);
            }
            KeyAgreement keyAgreement = KeyAgreement.getInstance(this.keyAgreementOID.getId(), provider);
            keyAgreement.init((Key)privateKey, secureRandom);
            keyAgreement.doPhase(publicKey2, true);
            SecretKey secretKey2 = keyAgreement.generateSecret(this.keyEncryptionOID.getId());
            Cipher cipher2 = CMSEnvelopedHelper.INSTANCE.createSymmetricCipher(this.keyEncryptionOID.getId(), provider);
            cipher2.init(3, (Key)secretKey2, secureRandom);
            byte[] byArray = cipher2.wrap(secretKey);
            DEROctetString dEROctetString2 = new DEROctetString(byArray);
            ((ASN1EncodableVector)object).add(new RecipientEncryptedKey(keyAgreeRecipientIdentifier, dEROctetString2));
        }
        return new RecipientInfo(new KeyAgreeRecipientInfo(originatorIdentifierOrKey, dEROctetString, (AlgorithmIdentifier)object2, new DERSequence((ASN1EncodableVector)object)));
    }

    private static OriginatorPublicKey createOriginatorPublicKey(PublicKey publicKey) throws IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(publicKey.getEncoded()));
        return new OriginatorPublicKey(new AlgorithmIdentifier(subjectPublicKeyInfo.getAlgorithmId().getObjectId(), DERNull.INSTANCE), subjectPublicKeyInfo.getPublicKeyData().getBytes());
    }
}

