/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.jruby.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.jruby.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.jruby.org.bouncycastle.crypto.KeyGenerationParameters;
import org.jruby.org.bouncycastle.crypto.params.ECDomainParameters;
import org.jruby.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.jruby.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.jruby.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.jruby.org.bouncycastle.math.ec.ECConstants;
import org.jruby.org.bouncycastle.math.ec.ECPoint;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        ECKeyGenerationParameters eCKeyGenerationParameters = (ECKeyGenerationParameters)keyGenerationParameters;
        this.random = eCKeyGenerationParameters.getRandom();
        this.params = eCKeyGenerationParameters.getDomainParameters();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n = bigInteger2.bitLength();
        while ((bigInteger = new BigInteger(n, this.random)).equals(ZERO) || bigInteger.compareTo(bigInteger2) >= 0) {
        }
        ECPoint eCPoint = this.params.getG().multiply(bigInteger);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(eCPoint, this.params), new ECPrivateKeyParameters(bigInteger, this.params));
    }
}

