/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.ContextAwareBlockBody;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledBlock
extends ContextAwareBlockBody {
    protected final CompiledBlockCallback callback;
    protected final boolean hasMultipleArgsHead;

    public static Block newCompiledClosure(ThreadContext context, IRubyObject self, Arity arity2, StaticScope scope, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        Binding binding2 = context.currentBinding(self, Visibility.PUBLIC);
        CompiledBlock body = new CompiledBlock(arity2, scope, callback, hasMultipleArgsHead, argumentType);
        return new Block(body, binding2);
    }

    public static Block newCompiledClosure(ThreadContext context, IRubyObject self, BlockBody body) {
        Binding binding2 = context.currentBinding(self, Visibility.PUBLIC);
        return new Block(body, binding2);
    }

    public static BlockBody newCompiledBlock(Arity arity2, StaticScope scope, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        return new CompiledBlock(arity2, scope, callback, hasMultipleArgsHead, argumentType);
    }

    protected CompiledBlock(Arity arity2, StaticScope scope, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        super(scope, arity2, argumentType);
        this.callback = callback;
        this.hasMultipleArgsHead = hasMultipleArgsHead;
    }

    public IRubyObject yieldSpecific(ThreadContext context, Binding binding2, Block.Type type2) {
        return this.yield(context, null, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        return this.yield(context, arg0, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        return this.yield(context, context.runtime.newArrayNoCopyLight(arg0, arg1), null, null, true, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        return this.yield(context, context.runtime.newArrayNoCopyLight(arg0, arg1, arg2), null, null, true, binding2, type2);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        return this.yield(context, value2, binding2, type2, Block.NULL_BLOCK);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject args2, IRubyObject self, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2) {
        return this.yield(context, args2, self, klass, aValue, binding2, type2, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2, Block block) {
        IRubyObject iRubyObject;
        IRubyObject self = this.prepareSelf(binding2);
        IRubyObject realArg = this.setupBlockArg(context.runtime, value2, self);
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, null, binding2);
        try {
            iRubyObject = this.callback.call(context, self, realArg, block);
            Object var13_12 = null;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject2;
            try {
                iRubyObject2 = this.handleNextJump(context, nj, type2);
                Object var13_13 = null;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                this.post(context, binding2, oldVis, lastFrame);
                throw throwable;
            }
            this.post(context, binding2, oldVis, lastFrame);
            return iRubyObject2;
        }
        this.post(context, binding2, oldVis, lastFrame);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext context, IRubyObject args2, IRubyObject self, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2, Block block) {
        IRubyObject iRubyObject;
        if (klass == null) {
            self = this.prepareSelf(binding2);
        }
        IRubyObject realArg = aValue ? this.setupBlockArgs(context, args2, self) : this.setupBlockArg(context.runtime, args2, self);
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, klass, binding2);
        try {
            iRubyObject = this.callback.call(context, self, realArg, block);
            Object var15_14 = null;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject2;
            try {
                iRubyObject2 = this.handleNextJump(context, nj, type2);
                Object var15_15 = null;
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                this.post(context, binding2, oldVis, lastFrame);
                throw throwable;
            }
            this.post(context, binding2, oldVis, lastFrame);
            return iRubyObject2;
        }
        this.post(context, binding2, oldVis, lastFrame);
        return iRubyObject;
    }

    private IRubyObject prepareSelf(Binding binding2) {
        IRubyObject self = binding2.getSelf();
        binding2.getFrame().setSelf(self);
        return self;
    }

    private IRubyObject handleNextJump(ThreadContext context, JumpException.NextJump nj, Block.Type type2) {
        return nj.getValue() == null ? context.runtime.getNil() : (IRubyObject)nj.getValue();
    }

    protected IRubyObject setupBlockArgs(ThreadContext context, IRubyObject value2, IRubyObject self) {
        switch (this.argumentType) {
            case 0: {
                return null;
            }
            case 1: 
            case 3: {
                return value2;
            }
        }
        return this.defaultArgsLogic(context.runtime, value2);
    }

    private IRubyObject defaultArgsLogic(Ruby ruby2, IRubyObject value2) {
        int length2 = ArgsUtil.arrayLength(value2);
        switch (length2) {
            case 0: {
                return ruby2.getNil();
            }
            case 1: {
                return ((RubyArray)value2).eltInternal(0);
            }
        }
        this.blockArgWarning(ruby2, length2);
        return value2;
    }

    private void blockArgWarning(Ruby ruby2, int length2) {
        ruby2.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + length2 + " for 1)");
    }

    protected IRubyObject setupBlockArg(Ruby ruby2, IRubyObject value2, IRubyObject self) {
        switch (this.argumentType) {
            case 0: {
                return null;
            }
            case 1: 
            case 3: {
                return ArgsUtil.convertToRubyArray(ruby2, value2, this.hasMultipleArgsHead);
            }
        }
        return this.defaultArgLogic(ruby2, value2);
    }

    private IRubyObject defaultArgLogic(Ruby ruby2, IRubyObject value2) {
        if (value2 == null) {
            return this.warnMultiReturnNil(ruby2);
        }
        return value2;
    }

    public String getFile() {
        return this.callback.getFile();
    }

    public int getLine() {
        return this.callback.getLine();
    }

    private IRubyObject warnMultiReturnNil(Ruby ruby2) {
        ruby2.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (0 for 1)");
        return ruby2.getNil();
    }
}

