/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import org.jruby.RubyArray;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ThreeVarDynamicScope;

public class FourVarDynamicScope
extends ThreeVarDynamicScope {
    private static final int SIZE = 4;
    private static final String SIZE_ERROR = "FourVarDynamicScope only supports scopes with four variables";
    private static final String GROW_ERROR = "FourVarDynamicScope cannot be grown; use ManyVarsDynamicScope";
    protected IRubyObject variableValueThree;

    public FourVarDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
    }

    public FourVarDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    public void growIfNeeded() {
        this.growIfNeeded(4, GROW_ERROR);
    }

    public DynamicScope cloneScope() {
        return new ThreeVarDynamicScope(this.staticScope, this.parent);
    }

    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValueZero, this.variableValueOne, this.variableValueTwo, this.variableValueThree};
    }

    public IRubyObject getValue(int offset2, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset2, depth - 1);
        }
        assert (offset2 < 4) : "FourVarDynamicScope only supports scopes with four variables";
        switch (offset2) {
            case 0: {
                return this.variableValueZero;
            }
            case 1: {
                return this.variableValueOne;
            }
            case 2: {
                return this.variableValueTwo;
            }
            case 3: {
                return this.variableValueThree;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    public IRubyObject getValueOrNil(int offset2, int depth, IRubyObject nil) {
        if (depth > 0) {
            return this.parent.getValueOrNil(offset2, depth - 1, nil);
        }
        return this.getValueDepthZeroOrNil(offset2, nil);
    }

    public IRubyObject getValueDepthZeroOrNil(int offset2, IRubyObject nil) {
        assert (offset2 < 4) : "FourVarDynamicScope only supports scopes with four variables";
        switch (offset2) {
            case 0: {
                if (this.variableValueZero == null) {
                    this.variableValueZero = nil;
                    return this.variableValueZero;
                }
                return this.variableValueZero;
            }
            case 1: {
                if (this.variableValueOne == null) {
                    this.variableValueOne = nil;
                    return this.variableValueOne;
                }
                return this.variableValueOne;
            }
            case 2: {
                if (this.variableValueTwo == null) {
                    this.variableValueTwo = nil;
                    return this.variableValueTwo;
                }
                return this.variableValueTwo;
            }
            case 3: {
                if (this.variableValueThree == null) {
                    this.variableValueThree = nil;
                    return this.variableValueThree;
                }
                return this.variableValueThree;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    public IRubyObject getValueThreeDepthZeroOrNil(IRubyObject nil) {
        if (this.variableValueThree == null) {
            this.variableValueThree = nil;
            return this.variableValueThree;
        }
        return this.variableValueThree;
    }

    public IRubyObject setValue(int offset2, IRubyObject value2, int depth) {
        if (depth > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
            return this.parent.setValue(offset2, value2, depth - 1);
        }
        assert (offset2 < 4) : "FourVarDynamicScope only supports scopes with four variables";
        switch (offset2) {
            case 0: {
                this.variableValueZero = value2;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = value2;
                return this.variableValueOne;
            }
            case 2: {
                this.variableValueTwo = value2;
                return this.variableValueTwo;
            }
            case 3: {
                this.variableValueThree = value2;
                return this.variableValueThree;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    public IRubyObject setValueDepthZero(IRubyObject value2, int offset2) {
        assert (offset2 < 4) : "FourVarDynamicScope only supports scopes with four variables";
        switch (offset2) {
            case 0: {
                this.variableValueZero = value2;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = value2;
                return this.variableValueOne;
            }
            case 2: {
                this.variableValueTwo = value2;
                return this.variableValueTwo;
            }
            case 3: {
                this.variableValueThree = value2;
                return this.variableValueThree;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    public IRubyObject setValueThreeDepthZero(IRubyObject value2) {
        this.variableValueThree = value2;
        return this.variableValueThree;
    }

    public void setArgValues(IRubyObject[] values2, int size2) {
        assert (size2 <= 4) : "FourVarDynamicScope only supports scopes with four variables";
        switch (size2) {
            case 4: {
                this.variableValueThree = values2[3];
            }
            case 3: {
                this.variableValueTwo = values2[2];
            }
            case 2: {
                this.variableValueOne = values2[1];
            }
            case 1: {
                this.variableValueZero = values2[0];
            }
        }
    }

    public void setEndArgValues(IRubyObject[] values2, int index2, int size2) {
        assert (size2 <= 3) : "FourVarDynamicScope only supports scopes with four variables, not " + size2;
        assert (index2 + size2 <= 4) : "FourVarDynamicScope only supports scopes with four variables, not " + (index2 + size2);
        int start2 = values2.length - size2;
        switch (index2) {
            case 0: {
                switch (size2) {
                    case 4: {
                        this.variableValueThree = values2[start2 + 3];
                    }
                    case 3: {
                        this.variableValueTwo = values2[start2 + 2];
                    }
                    case 2: {
                        this.variableValueOne = values2[start2 + 1];
                    }
                    case 1: {
                        this.variableValueZero = values2[start2];
                    }
                }
                break;
            }
            case 1: {
                switch (size2) {
                    case 3: 
                    case 4: {
                        this.variableValueThree = values2[start2 + 2];
                    }
                    case 2: {
                        this.variableValueTwo = values2[start2 + 1];
                    }
                    case 1: {
                        this.variableValueOne = values2[start2];
                    }
                }
                break;
            }
            case 2: {
                switch (size2) {
                    case 2: 
                    case 3: 
                    case 4: {
                        this.variableValueThree = values2[start2 + 1];
                    }
                    case 1: {
                        this.variableValueTwo = values2[start2];
                    }
                }
                break;
            }
            case 3: {
                switch (size2) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        this.variableValueThree = values2[start2];
                    }
                }
            }
        }
    }

    public void setArgValues(IRubyObject arg0) {
        this.variableValueZero = arg0;
    }

    public void setArgValues(IRubyObject arg0, IRubyObject arg1) {
        this.variableValueZero = arg0;
        this.variableValueOne = arg1;
    }

    public void setArgValues(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        this.variableValueZero = arg0;
        this.variableValueOne = arg1;
        this.variableValueTwo = arg2;
    }

    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int totalArgs = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        assert (totalArgs <= 4) : "FourVarDynamicScope only supports scopes with four variables";
        if (this.staticScope.getRestArg() < 0) {
            switch (totalArgs) {
                case 0: {
                    return IRubyObject.NULL_ARRAY;
                }
                case 1: {
                    return new IRubyObject[]{this.variableValueZero};
                }
                case 2: {
                    return new IRubyObject[]{this.variableValueZero, this.variableValueOne};
                }
                case 3: {
                    return new IRubyObject[]{this.variableValueZero, this.variableValueOne, this.variableValueTwo};
                }
                case 4: {
                    return new IRubyObject[]{this.variableValueZero, this.variableValueOne, this.variableValueTwo, this.variableValueThree};
                }
            }
            throw new RuntimeException("more args requested than available variables");
        }
        IRubyObject restArg = this.getValue(this.staticScope.getRestArg(), 0);
        assert (restArg != null);
        RubyArray splattedArgs = RuntimeHelpers.splatValue(restArg);
        IRubyObject[] argValues = new IRubyObject[totalArgs + splattedArgs.size()];
        System.arraycopy(splattedArgs.toJavaArray(), 0, argValues, totalArgs, splattedArgs.size());
        switch (totalArgs) {
            case 4: {
                argValues[3] = this.variableValueThree;
            }
            case 3: {
                argValues[2] = this.variableValueTwo;
            }
            case 2: {
                argValues[1] = this.variableValueOne;
            }
            case 1: {
                argValues[0] = this.variableValueZero;
            }
        }
        return argValues;
    }
}

