/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.actions.SoapUIPreferencesAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ArgumentBuilder;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolHost;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.support.wsdl.CachedWsdlLoader;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.settings.ProjectSettings;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.support.action.DefaultActionList;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormTextField;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractToolsAction<T extends ModelItem>
extends AbstractAction {
    private static final Logger log = Logger.getLogger(AbstractToolsAction.class);
    protected static final String WSDL = "WSDL";
    protected static final String CACHED_WSDL = "Use cached WSDL";
    protected static final String JAVA_ARGS = "Java Args";
    protected static final String TOOL_ARGS = "Tool Args";
    protected final T modelItem;
    protected XFormDialog dialog;
    protected String valuesSettingID;
    private XFormField useCached;
    private boolean fixedWSDL = false;
    private Action toolsSettingsAction = new ShowIntegratedToolsSettingsAction();

    public AbstractToolsAction(T modelItem, String name, String description) {
        super(name);
        this.modelItem = modelItem;
        this.valuesSettingID = this.getClass().getName() + "@values";
        this.valuesSettingID = modelItem == null ? this.valuesSettingID + "-global" : this.valuesSettingID + "-local";
        this.putValue("ShortDescription", description);
    }

    public String getValuesSettingID() {
        return this.valuesSettingID;
    }

    public void setValuesSettingID(String valuesSettingID) {
        this.valuesSettingID = valuesSettingID;
    }

    public void setFixedWSDL(boolean b) {
        this.fixedWSDL = b;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dialog = this.buildDialog();
        if (this.dialog == null) {
            try {
                this.generate(this.initValues(), UISupport.getToolHost());
            }
            catch (Exception e1) {
                UISupport.showErrorMessage(e1);
                e1.printStackTrace();
            }
        } else {
            StringToStringMap values = this.initValues();
            this.dialog.setValues(values);
            this.dialog.setVisible(true);
        }
    }

    protected StringToStringMap initValues() {
        String projectRoot;
        StringToStringMap result;
        String settingValues = this.modelItem == null ? SoapUI.getSettings().getString(this.valuesSettingID, null) : this.modelItem.getSettings().getString(this.valuesSettingID, null);
        StringToStringMap stringToStringMap = result = settingValues == null ? new StringToStringMap() : StringToStringMap.fromXml(settingValues);
        if (this.modelItem instanceof Interface) {
            this.initWSDL(result, (Interface)this.modelItem);
        }
        if (this.dialog != null && this.modelItem != null && (projectRoot = this.modelItem.getSettings().getString(ProjectSettings.PROJECT_ROOT, null)) != null) {
            this.dialog.setFormFieldProperty(ProjectSettings.PROJECT_ROOT, projectRoot);
        }
        return result;
    }

    protected XFormDialog buildDialog() {
        return null;
    }

    protected void addWSDLFields(XForm mainForm) {
        if (!this.fixedWSDL) {
            XFormTextField tf = mainForm.addTextField(WSDL, "url to wsdl", XForm.FieldType.URL);
            if (this.modelItem instanceof Interface) {
                this.useCached = mainForm.addCheckBox(CACHED_WSDL, null);
                this.useCached.addComponentEnabler(tf, "false");
            }
        } else if (this.modelItem instanceof Interface) {
            this.useCached = mainForm.addCheckBox(CACHED_WSDL, null);
        }
    }

    protected void initWSDL(StringToStringMap values, Interface iface) {
        boolean cached = iface.isCached();
        if (this.useCached != null) {
            this.useCached.setEnabled(cached);
        }
        if (!values.containsKey(CACHED_WSDL)) {
            values.put(CACHED_WSDL, Boolean.toString(cached));
        }
        if (values.getBoolean(CACHED_WSDL) || !values.hasValue(WSDL)) {
            values.put(WSDL, iface.getDefinition());
        }
    }

    protected abstract void generate(StringToStringMap var1, ToolHost var2) throws Exception;

    public void run(ToolHost toolHost) throws Exception {
        this.generate(this.initValues(), toolHost);
    }

    public void onClose() {
        if (this.dialog == null) {
            return;
        }
        if (this.modelItem == null) {
            SoapUI.getSettings().setString(this.valuesSettingID, this.dialog.getValues().toXml());
        } else {
            this.modelItem.getSettings().setString(this.valuesSettingID, this.dialog.getValues().toXml());
        }
    }

    protected String getWsdlUrl(StringToStringMap values) {
        String wsdl = (String)values.get(WSDL);
        boolean useCached = values.getBoolean(CACHED_WSDL);
        if (wsdl == null && !useCached && this.modelItem instanceof Interface) {
            return ((Interface)this.modelItem).getDefinition();
        }
        Interface iface = (Interface)this.modelItem;
        if (useCached && iface.isCached()) {
            try {
                File tempFile = File.createTempFile("tempdir", null);
                String path = tempFile.getAbsolutePath();
                tempFile.delete();
                CachedWsdlLoader loader = (CachedWsdlLoader)iface.createWsdlLoader();
                wsdl = loader.saveDefinition(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return wsdl;
    }

    protected String buildClasspath(File jarDir) {
        String[] jars = jarDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        StringBuilder classpath = new StringBuilder();
        for (int c = 0; c < jars.length; ++c) {
            if (c > 0) {
                classpath.append(File.pathSeparatorChar);
            }
            classpath.append(jars[c]);
        }
        return classpath.toString();
    }

    protected ActionList buildDefaultActions(String helpUrl) {
        DefaultActionList actions = new DefaultActionList("Actions");
        if (helpUrl != null) {
            actions.addAction(new ShowOnlineHelpAction(helpUrl));
            actions.addSeparator();
        }
        actions.addAction(this.createRunOption());
        actions.addAction(new CloseAction());
        if (this.toolsSettingsAction != null) {
            actions.addAction(this.toolsSettingsAction);
        }
        return actions;
    }

    public Action getToolsSettingsAction() {
        return this.toolsSettingsAction;
    }

    public void setToolsSettingsAction(Action toolsSettingsAction) {
        this.toolsSettingsAction = toolsSettingsAction;
    }

    protected Action createRunOption() {
        return new GenerateAction();
    }

    protected String getDefinition() {
        if (this.modelItem == null) {
            return "";
        }
        String definition = ((Interface)this.modelItem).getDefinition();
        if (definition.startsWith("file:")) {
            definition = definition.substring(5);
        }
        return definition;
    }

    protected void addJavaArgs(StringToStringMap values, ArgumentBuilder builder) {
        String[] javaArgs = Tools.tokenizeArgs((String)values.get(JAVA_ARGS));
        if (javaArgs != null) {
            builder.addArgs(javaArgs);
        }
    }

    protected void addToolArgs(StringToStringMap values, ArgumentBuilder builder) {
        String[] toolArgs = Tools.tokenizeArgs((String)values.get(TOOL_ARGS));
        if (toolArgs != null) {
            builder.addArgs(toolArgs);
        }
    }

    protected XForm buildArgsForm(XFormDialogBuilder builder, boolean addJavaArgs, String toolName) {
        XForm argsForm = builder.createForm("Custom Args");
        if (addJavaArgs) {
            argsForm.addTextField(JAVA_ARGS, "additional arguments to java", XForm.FieldType.TEXT);
        }
        argsForm.addTextField(TOOL_ARGS, "additional arguments to " + toolName, XForm.FieldType.TEXT);
        return argsForm;
    }

    public void closeDialog() {
        this.onClose();
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    protected final class GenerateAction
    extends AbstractAction {
        public GenerateAction() {
            super("Generate");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (AbstractToolsAction.this.dialog.validate()) {
                    AbstractToolsAction.this.generate(AbstractToolsAction.this.dialog.getValues(), UISupport.getToolHost());
                }
            }
            catch (Exception e1) {
                UISupport.showErrorMessage(e1);
            }
        }
    }

    protected final class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Close");
        }

        public void actionPerformed(ActionEvent e) {
            AbstractToolsAction.this.closeDialog();
        }
    }

    public static final class ShowIntegratedToolsSettingsAction
    extends AbstractAction {
        public ShowIntegratedToolsSettingsAction() {
            super("Tools");
        }

        public void actionPerformed(ActionEvent e) {
            SoapUIPreferencesAction.getInstance().show("Tools");
        }
    }
}

