/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.MultipartMessageSupport;
import com.eviware.soapui.impl.wsdl.submit.transports.http.PostResponseDataSource;
import com.eviware.soapui.impl.wsdl.submit.transports.http.SSLInfo;
import com.eviware.soapui.impl.wsdl.submit.transports.http.TimeablePostMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.impl.wsdl.support.xsd.SchemaUtils;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.types.StringToStringMap;
import java.io.ByteArrayOutputStream;
import javax.xml.namespace.QName;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlHexBinary;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MimeMessageResponse
implements WsdlResponse {
    private final WsdlRequest wsdlRequest;
    private long timeTaken;
    private long responseContentLength;
    private StringToStringMap requestHeaders;
    private StringToStringMap responseHeaders;
    private final String requestContent;
    private SSLInfo sslInfo;
    private MultipartMessageSupport mmSupport;
    private long timestamp;

    public MimeMessageResponse(WsdlRequest wsdlRequest, TimeablePostMethod postMethod, String requestContent) {
        this.wsdlRequest = wsdlRequest;
        this.requestContent = requestContent;
        this.timeTaken = postMethod.getTimeTaken();
        this.timestamp = System.currentTimeMillis();
        try {
            this.initHeaders(postMethod);
            this.sslInfo = postMethod.getSSLInfo();
            PostResponseDataSource postResponseDataSource = new PostResponseDataSource(postMethod);
            this.responseContentLength = postResponseDataSource.getDataSize();
            Header h = postMethod.getResponseHeader("Content-Type");
            HeaderElement[] elements = h.getElements();
            String rootPartId = null;
            String multipartType = null;
            for (HeaderElement element : elements) {
                String name = element.getName().toUpperCase();
                if (!name.startsWith("MULTIPART/")) continue;
                NameValuePair parameter = element.getParameterByName("start");
                if (parameter != null) {
                    rootPartId = parameter.getValue();
                }
                if ((parameter = element.getParameterByName("type")) == null) continue;
                multipartType = parameter.getValue();
            }
            this.mmSupport = new MultipartMessageSupport(postResponseDataSource, rootPartId);
            if (wsdlRequest.getSettings().getBoolean(HttpSettings.INCLUDE_RESPONSE_IN_TIME_TAKEN)) {
                this.timeTaken = postMethod.getTimeTakenUntilNow();
            }
            if (wsdlRequest.isExpandMtomResponseAttachments() && "application/xop+xml".equals(multipartType)) {
                this.expandMtomAttachments();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void expandMtomAttachments() {
        try {
            XmlObject[] includes;
            XmlObject xmlObject = XmlObject.Factory.parse((String)this.getContentAsString());
            for (XmlObject include : includes = xmlObject.selectPath("declare namespace xop='http://www.w3.org/2004/08/xop/include'; //xop:Include")) {
                SchemaTypeSystem typeSystem;
                SchemaGlobalElement schemaElement;
                Element elm = (Element)include.getDomNode();
                String href = elm.getAttribute("href");
                Attachment attachment = this.mmSupport.getAttachmentWithContentId("<" + href.substring(4) + ">");
                if (attachment == null) continue;
                ByteArrayOutputStream data = Tools.readAll(attachment.getInputStream(), 0L);
                byte[] byteArray = data.toByteArray();
                XmlCursor cursor = include.newCursor();
                cursor.toParent();
                XmlObject parentXmlObject = cursor.getObject();
                cursor.dispose();
                SchemaType schemaType = parentXmlObject.schemaType();
                Node parentNode = elm.getParentNode();
                if (schemaType.isNoType() && (schemaElement = (typeSystem = this.wsdlRequest.getOperation().getInterface().getWsdlContext().getSchemaTypeSystem()).findElement(new QName(parentNode.getNamespaceURI(), parentNode.getLocalName()))) != null) {
                    schemaType = schemaElement.getType();
                }
                String txt = null;
                txt = SchemaUtils.isInstanceOf(schemaType, XmlHexBinary.type) ? new String(Hex.encodeHex((byte[])byteArray)) : new String(Base64.encodeBase64((byte[])byteArray));
                parentNode.replaceChild(elm.getOwnerDocument().createTextNode(txt), elm);
            }
            this.mmSupport.setResponseContent(xmlObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SSLInfo getSSLInfo() {
        return this.sslInfo;
    }

    public long getContentLength() {
        return this.responseContentLength;
    }

    public Request getRequest() {
        return this.wsdlRequest;
    }

    public long getTimeTaken() {
        return this.timeTaken;
    }

    private void initHeaders(TimeablePostMethod postMethod) {
        Header[] headers;
        this.requestHeaders = new StringToStringMap();
        for (Header header : headers = postMethod.getRequestHeaders()) {
            this.requestHeaders.put(header.getName(), header.getValue());
        }
        this.responseHeaders = new StringToStringMap();
        for (Header header : headers = postMethod.getResponseHeaders()) {
            this.responseHeaders.put(header.getName(), header.getValue());
        }
        this.responseHeaders.put("#status#", postMethod.getStatusLine().toString());
    }

    public StringToStringMap getRequestHeaders() {
        return this.requestHeaders;
    }

    public StringToStringMap getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getRequestContent() {
        return this.requestContent;
    }

    public void setResponseContent(String responseContent) {
        this.mmSupport.setResponseContent(responseContent);
    }

    public Attachment[] getAttachments() {
        return this.mmSupport.getAttachments();
    }

    public Attachment[] getAttachmentsForPart(String partName) {
        return this.mmSupport.getAttachmentsForPart(partName);
    }

    public String getContentAsString() {
        return this.mmSupport.getContentAsString();
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

