/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wsdl;

import com.eviware.soapui.impl.wsdl.support.wsdl.UrlWsdlLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Fault;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlUtils {
    private static final Logger log = Logger.getLogger(WsdlUtils.class);
    private static WSDLReader wsdlReader;

    public static <T extends ExtensibilityElement> T getExtensiblityElement(List list, Class<T> clazz) {
        List<T> elements = WsdlUtils.getExtensiblityElements(list, clazz);
        return (T)(elements.isEmpty() ? null : (ExtensibilityElement)elements.get(0));
    }

    public static <T extends ExtensibilityElement> List<T> getExtensiblityElements(List list, Class<T> clazz) {
        ArrayList<ExtensibilityElement> result = new ArrayList<ExtensibilityElement>();
        for (ExtensibilityElement elm : list) {
            if (!clazz.isAssignableFrom(elm.getClass())) continue;
            result.add(elm);
        }
        return result;
    }

    public static String getSoapAction(BindingOperation operation) {
        List list = operation.getExtensibilityElements();
        SOAPOperation soapOperation = WsdlUtils.getExtensiblityElement(list, SOAPOperation.class);
        if (soapOperation != null) {
            return soapOperation.getSoapActionURI();
        }
        SOAP12Operation soap12Operation = WsdlUtils.getExtensiblityElement(list, SOAP12Operation.class);
        if (soap12Operation != null) {
            return soap12Operation.getSoapActionURI();
        }
        return null;
    }

    public static String[] getEndpointsForBinding(Definition definition, Binding binding) {
        ArrayList<String> result = new ArrayList<String>();
        Map map = definition.getAllServices();
        for (Service service : map.values()) {
            Map portMap = service.getPorts();
            for (Port port : portMap.values()) {
                String endpoint;
                if (port.getBinding() != binding || (endpoint = WsdlUtils.getSoapEndpoint(port)) == null) continue;
                result.add(endpoint);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static Binding findBindingForOperation(Definition definition, BindingOperation bindingOperation) {
        List bindingOperations;
        Binding binding;
        Map services = definition.getAllServices();
        Iterator s = services.values().iterator();
        while (s.hasNext()) {
            Map ports = ((Service)s.next()).getPorts();
            Iterator p = ports.values().iterator();
            while (p.hasNext()) {
                binding = ((Port)p.next()).getBinding();
                bindingOperations = binding.getBindingOperations();
                for (BindingOperation op : bindingOperations) {
                    if (!op.getName().equals(bindingOperation.getName())) continue;
                    return binding;
                }
            }
        }
        Map bindings = definition.getAllBindings();
        Iterator names = bindings.keySet().iterator();
        while (names.hasNext()) {
            binding = definition.getBinding((QName)names.next());
            bindingOperations = binding.getBindingOperations();
            for (BindingOperation op : bindingOperations) {
                if (!op.getName().equals(bindingOperation.getName())) continue;
                return binding;
            }
        }
        return null;
    }

    public static boolean isInputSoapEncoded(BindingOperation bindingOperation) {
        SOAPBody soapBody = WsdlUtils.getExtensiblityElement(bindingOperation.getBindingInput().getExtensibilityElements(), SOAPBody.class);
        if (soapBody != null) {
            return soapBody.getUse() != null && soapBody.getUse().equalsIgnoreCase("encoded") && (soapBody.getEncodingStyles() == null || soapBody.getEncodingStyles().contains("http://schemas.xmlsoap.org/soap/encoding/"));
        }
        SOAP12Body soap12Body = WsdlUtils.getExtensiblityElement(bindingOperation.getBindingInput().getExtensibilityElements(), SOAP12Body.class);
        if (soap12Body != null) {
            return soap12Body.getUse() != null && soap12Body.getUse().equalsIgnoreCase("encoded") && (soap12Body.getEncodingStyle() == null || soap12Body.getEncodingStyle().equals("http://schemas.xmlsoap.org/soap/encoding/"));
        }
        return false;
    }

    public static boolean isOutputSoapEncoded(BindingOperation bindingOperation) {
        BindingOutput bindingOutput = bindingOperation.getBindingOutput();
        if (bindingOutput == null) {
            return false;
        }
        SOAPBody soapBody = WsdlUtils.getExtensiblityElement(bindingOutput.getExtensibilityElements(), SOAPBody.class);
        if (soapBody != null) {
            return soapBody.getUse() != null && soapBody.getUse().equalsIgnoreCase("encoded") && (soapBody.getEncodingStyles() == null || soapBody.getEncodingStyles().contains("http://schemas.xmlsoap.org/soap/encoding/"));
        }
        SOAP12Body soap12Body = WsdlUtils.getExtensiblityElement(bindingOutput.getExtensibilityElements(), SOAP12Body.class);
        if (soap12Body != null) {
            return soap12Body.getUse() != null && soap12Body.getUse().equalsIgnoreCase("encoded") && (soap12Body.getEncodingStyle() == null || soap12Body.getEncodingStyle().equals("http://schemas.xmlsoap.org/soap/encoding/"));
        }
        return false;
    }

    public static boolean isRpc(Definition definition, BindingOperation bindingOperation) {
        SOAPOperation soapOperation = WsdlUtils.getExtensiblityElement(bindingOperation.getExtensibilityElements(), SOAPOperation.class);
        if (soapOperation != null && soapOperation.getStyle() != null) {
            return soapOperation.getStyle().equalsIgnoreCase("rpc");
        }
        SOAP12Operation soap12Operation = WsdlUtils.getExtensiblityElement(bindingOperation.getExtensibilityElements(), SOAP12Operation.class);
        if (soap12Operation != null && soap12Operation.getStyle() != null) {
            return soap12Operation.getStyle().equalsIgnoreCase("rpc");
        }
        Binding binding = WsdlUtils.findBindingForOperation(definition, bindingOperation);
        if (binding == null) {
            log.error((Object)("Failed to find binding for operation [" + bindingOperation.getName() + "] in definition [" + definition.getDocumentBaseURI() + "]"));
            return false;
        }
        return WsdlUtils.isRpc(binding);
    }

    public static boolean isRpc(Binding binding) {
        SOAPBinding soapBinding = WsdlUtils.getExtensiblityElement(binding.getExtensibilityElements(), SOAPBinding.class);
        if (soapBinding != null) {
            return "rpc".equalsIgnoreCase(soapBinding.getStyle());
        }
        SOAP12Binding soap12Binding = WsdlUtils.getExtensiblityElement(binding.getExtensibilityElements(), SOAP12Binding.class);
        if (soap12Binding != null) {
            return "rpc".equalsIgnoreCase(soap12Binding.getStyle());
        }
        return false;
    }

    public static Part[] getInputParts(BindingOperation operation) {
        ArrayList<Part> result;
        block4: {
            SOAPBody soapBody;
            Message msg;
            block2: {
                SOAP12Body soap12Body;
                block3: {
                    result = new ArrayList<Part>();
                    msg = operation.getOperation().getInput().getMessage();
                    soapBody = WsdlUtils.getExtensiblityElement(operation.getBindingInput().getExtensibilityElements(), SOAPBody.class);
                    if (soapBody != null && soapBody.getParts() != null) break block2;
                    soap12Body = WsdlUtils.getExtensiblityElement(operation.getBindingInput().getExtensibilityElements(), SOAP12Body.class);
                    if (soap12Body != null && soap12Body.getParts() != null) break block3;
                    if (msg == null) break block4;
                    result.addAll(msg.getOrderedParts(null));
                    break block4;
                }
                for (String partName : soap12Body.getParts()) {
                    Part part = msg.getPart(partName);
                    result.add(part);
                }
                break block4;
            }
            for (String partName : soapBody.getParts()) {
                Part part = msg.getPart(partName);
                result.add(part);
            }
        }
        return result.toArray(new Part[result.size()]);
    }

    public static boolean isAttachmentInputPart(Part part, BindingOperation operation) {
        return WsdlUtils.getInputMultipartContent(part, operation).length > 0;
    }

    public static boolean isAttachmentOutputPart(Part part, BindingOperation operation) {
        return WsdlUtils.getOutputMultipartContent(part, operation).length > 0;
    }

    public static MIMEContent[] getOutputMultipartContent(Part part, BindingOperation operation) {
        MIMEMultipartRelated multipartOutput = WsdlUtils.getExtensiblityElement(operation.getBindingOutput().getExtensibilityElements(), MIMEMultipartRelated.class);
        return WsdlUtils.getContentParts(part, multipartOutput);
    }

    public static MIMEContent[] getInputMultipartContent(Part part, BindingOperation operation) {
        MIMEMultipartRelated multipartInput = WsdlUtils.getExtensiblityElement(operation.getBindingInput().getExtensibilityElements(), MIMEMultipartRelated.class);
        return WsdlUtils.getContentParts(part, multipartInput);
    }

    public static MIMEContent[] getContentParts(Part part, MIMEMultipartRelated multipart) {
        ArrayList<MIMEContent> result = new ArrayList<MIMEContent>();
        if (multipart != null) {
            List parts = multipart.getMIMEParts();
            for (int c = 0; c < parts.size(); ++c) {
                List<MIMEContent> contentParts = WsdlUtils.getExtensiblityElements(((MIMEPart)parts.get(c)).getExtensibilityElements(), MIMEContent.class);
                for (MIMEContent content : contentParts) {
                    if (!content.getPart().equals(part.getName())) continue;
                    result.add(content);
                }
            }
        }
        return result.toArray(new MIMEContent[result.size()]);
    }

    public static Part[] getFaultParts(BindingOperation bindingOperation, String faultName) {
        ArrayList result = new ArrayList();
        BindingFault bindingFault = bindingOperation.getBindingFault(faultName);
        SOAPFault soapFault = WsdlUtils.getExtensiblityElement(bindingFault.getExtensibilityElements(), SOAPFault.class);
        if (soapFault != null && soapFault.getName() != null) {
            result.addAll(bindingOperation.getOperation().getFault(soapFault.getName()).getMessage().getOrderedParts(null));
        } else {
            SOAP12Fault soap12Fault = WsdlUtils.getExtensiblityElement(bindingFault.getExtensibilityElements(), SOAP12Fault.class);
            if (soap12Fault != null && soap12Fault.getName() != null) {
                result.addAll(bindingOperation.getOperation().getFault(soap12Fault.getName()).getMessage().getOrderedParts(null));
            } else {
                result.addAll(bindingOperation.getOperation().getFault(faultName).getMessage().getOrderedParts(null));
            }
        }
        return result.toArray(new Part[result.size()]);
    }

    public static Part[] getOutputParts(BindingOperation operation) {
        BindingOutput bindingOutput = operation.getBindingOutput();
        if (bindingOutput == null) {
            return new Part[0];
        }
        ArrayList<Part> result = new ArrayList<Part>();
        Message msg = operation.getOperation().getOutput().getMessage();
        SOAPBody soapBody = WsdlUtils.getExtensiblityElement(bindingOutput.getExtensibilityElements(), SOAPBody.class);
        if (soapBody == null || soapBody.getParts() == null) {
            SOAP12Body soap12Body = WsdlUtils.getExtensiblityElement(bindingOutput.getExtensibilityElements(), SOAP12Body.class);
            if (soap12Body == null || soap12Body.getParts() == null) {
                result.addAll(msg.getOrderedParts(null));
            } else {
                for (String partName : soap12Body.getParts()) {
                    Part part = msg.getPart(partName);
                    result.add(part);
                }
            }
        } else {
            for (String partName : soapBody.getParts()) {
                Part part = msg.getPart(partName);
                result.add(part);
            }
        }
        return result.toArray(new Part[result.size()]);
    }

    public static boolean isMultipartRequest(Definition definition, BindingOperation bindingOperation) {
        return WsdlUtils.getExtensiblityElement(bindingOperation.getBindingInput().getExtensibilityElements(), MIMEMultipartRelated.class) != null;
    }

    public static String getSoapEndpoint(Port port) {
        SOAPAddress soapAddress = WsdlUtils.getExtensiblityElement(port.getExtensibilityElements(), SOAPAddress.class);
        if (soapAddress != null) {
            return soapAddress.getLocationURI();
        }
        SOAP12Address soap12Address = WsdlUtils.getExtensiblityElement(port.getExtensibilityElements(), SOAP12Address.class);
        if (soap12Address != null) {
            return soap12Address.getLocationURI();
        }
        return null;
    }

    public static String getSoapBodyNamespace(List list) {
        SOAPBody soapBody = WsdlUtils.getExtensiblityElement(list, SOAPBody.class);
        if (soapBody != null) {
            return soapBody.getNamespaceURI();
        }
        SOAP12Body soap12Body = WsdlUtils.getExtensiblityElement(list, SOAP12Body.class);
        if (soap12Body != null) {
            return soap12Body.getNamespaceURI();
        }
        return null;
    }

    public static List<SoapHeader> getSoapHeaders(List list) {
        ArrayList<SoapHeader> result;
        block3: {
            block2: {
                result = new ArrayList<SoapHeader>();
                List<SOAPHeader> soapHeaders = WsdlUtils.getExtensiblityElements(list, SOAPHeader.class);
                if (soapHeaders == null || soapHeaders.isEmpty()) break block2;
                for (SOAPHeader header : soapHeaders) {
                    result.add(new Soap11Header(header));
                }
                break block3;
            }
            List<SOAP12Header> soap12Headers = WsdlUtils.getExtensiblityElements(list, SOAP12Header.class);
            if (soap12Headers == null || soap12Headers.isEmpty()) break block3;
            for (SOAP12Header header : soap12Headers) {
                result.add(new Soap12Header(header));
            }
        }
        return result;
    }

    public static synchronized Definition readDefinition(String wsdlUrl) throws Exception {
        if (wsdlReader == null) {
            WSDLFactory factory = WSDLFactory.newInstance();
            wsdlReader = factory.newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.verbose", true);
            wsdlReader.setFeature("javax.wsdl.importDocuments", true);
        }
        return wsdlReader.readWSDL((WSDLLocator)new UrlWsdlLoader(wsdlUrl));
    }

    public static class Soap12Header
    implements SoapHeader {
        private final SOAP12Header soapHeader;

        public Soap12Header(SOAP12Header soapHeader) {
            this.soapHeader = soapHeader;
        }

        public QName getMessage() {
            return this.soapHeader.getMessage();
        }

        public String getPart() {
            return this.soapHeader.getPart();
        }
    }

    public static class Soap11Header
    implements SoapHeader {
        private final SOAPHeader soapHeader;

        public Soap11Header(SOAPHeader soapHeader) {
            this.soapHeader = soapHeader;
        }

        public QName getMessage() {
            return this.soapHeader.getMessage();
        }

        public String getPart() {
            return this.soapHeader.getPart();
        }
    }

    public static interface SoapHeader {
        public QName getMessage();

        public String getPart();
    }
}

