/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.TestIntrospector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodValidator {
    private final TestIntrospector fIntrospector;
    private final List<Throwable> fErrors = new ArrayList<Throwable>();
    private final Class<?> fTestClass;

    public MethodValidator(Class<?> testClass) {
        this.fTestClass = testClass;
        this.fIntrospector = new TestIntrospector(testClass);
    }

    public void validateInstanceMethods() {
        this.validateTestMethods(After.class, false);
        this.validateTestMethods(Before.class, false);
        this.validateTestMethods(Test.class, false);
    }

    public void validateStaticMethods() {
        this.validateTestMethods(BeforeClass.class, true);
        this.validateTestMethods(AfterClass.class, true);
    }

    public List<Throwable> validateAllMethods() {
        this.validateNoArgConstructor();
        this.validateStaticMethods();
        this.validateInstanceMethods();
        return this.fErrors;
    }

    public void assertValid() throws InitializationError {
        if (!this.fErrors.isEmpty()) {
            throw new InitializationError(this.fErrors);
        }
    }

    public void validateNoArgConstructor() {
        try {
            this.fTestClass.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            this.fErrors.add(new Exception("Test class should have public zero-argument constructor", e));
        }
    }

    private void validateTestMethods(Class<? extends Annotation> annotation, boolean isStatic) {
        List<Method> methods = this.fIntrospector.getTestMethods(annotation);
        for (Method each : methods) {
            if (Modifier.isStatic(each.getModifiers()) != isStatic) {
                String state = isStatic ? "should" : "should not";
                this.fErrors.add(new Exception("Method " + each.getName() + "() " + state + " be static"));
            }
            if (!Modifier.isPublic(each.getModifiers())) {
                this.fErrors.add(new Exception("Method " + each.getName() + " should be public"));
            }
            if (each.getReturnType() != Void.TYPE) {
                this.fErrors.add(new Exception("Method " + each.getName() + " should be void"));
            }
            if (each.getParameterTypes().length == 0) continue;
            this.fErrors.add(new Exception("Method " + each.getName() + " should have no parameters"));
        }
    }
}

