/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.addressing.eprs;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.soa.esb.addressing.eprs.InVMEpr;

public class DefaultInVMReplyToEpr
extends InVMEpr {
    private static ThreadLocal<Long> counter = new ThreadLocal();

    public DefaultInVMReplyToEpr(InVMEpr epr) {
        super(DefaultInVMReplyToEpr.createEprAndCourier());
    }

    private static InVMEpr createEprAndCourier() {
        try {
            InVMEpr epr = new InVMEpr(URI.create("invm://thread-" + Thread.currentThread().getId() + "-" + DefaultInVMReplyToEpr.getNextCounter()));
            epr.setTemporaryEPR(true);
            return epr;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unexpected Exception creating replyTo InVMEpr.", e);
        }
    }

    private static long getNextCounter() {
        Long current = counter.get();
        long value = current != null ? current + 1L : 0L;
        counter.set(value);
        return value;
    }
}

