/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.addressing.helpers;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.internal.soa.esb.addressing.helpers.PortReferenceHelper;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.internal.soa.esb.util.stax.StreamHelper;
import org.jboss.soa.esb.MarshalException;
import org.jboss.soa.esb.UnmarshalException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.PortReference;
import org.jboss.soa.esb.addressing.XMLUtil;
import org.jboss.soa.esb.addressing.eprs.EmailEpr;
import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.jboss.soa.esb.addressing.eprs.FTPSEpr;
import org.jboss.soa.esb.addressing.eprs.FileEpr;
import org.jboss.soa.esb.addressing.eprs.HTTPEpr;
import org.jboss.soa.esb.addressing.eprs.HibernateEpr;
import org.jboss.soa.esb.addressing.eprs.InVMEpr;
import org.jboss.soa.esb.addressing.eprs.JDBCEpr;
import org.jboss.soa.esb.addressing.eprs.JMSEpr;
import org.jboss.soa.esb.addressing.eprs.LogicalEPR;
import org.jboss.soa.esb.addressing.eprs.SFTPEpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPRHelper {
    public static final String EPR_TYPE = "type";
    private static final QName HEADER = new QName("header");

    public static void toXML(XMLStreamWriter out, QName name, EPR epr) throws XMLStreamException {
        EPRHelper.setSpecificEPR(epr);
        PortReferenceHelper.toXML(out, name, epr.getAddr());
    }

    public static EPR fromXML(XMLStreamReader in) throws XMLStreamException {
        PortReference portReference = PortReferenceHelper.fromXML(in);
        return EPRHelper.getSpecificEPR(new EPR(portReference));
    }

    public static final String toXMLString(EPR epr) throws MarshalException {
        return EPRHelper.toXMLString(epr, XMLUtil.QNAME_FROM_TAG);
    }

    public static final String toXMLString(EPR epr, QName name) throws MarshalException {
        AssertArgument.isNotNull(epr, "epr");
        AssertArgument.isNotNull(name, "name");
        try {
            StringWriter writer = new StringWriter();
            XMLStreamWriter out = XMLHelper.getXMLStreamWriter(writer);
            if (XMLUtil.QNAME_TO_TAG.equals(name)) {
                String origURI = StreamHelper.writeStartElement(out, HEADER);
                EPRHelper.toXML(out, name, epr);
                StreamHelper.writeEndElement(out, HEADER.getPrefix(), origURI);
            } else {
                EPRHelper.toXML(out, name, epr);
            }
            out.flush();
            return writer.toString();
        }
        catch (XMLStreamException xmlse) {
            throw new MarshalException("Failed to serialise EPR.", xmlse);
        }
    }

    public static final EPR fromXMLString(String xml) throws UnmarshalException {
        AssertArgument.isNotNull(xml, "xml");
        try {
            StringReader reader = new StringReader(xml);
            XMLStreamReader in = XMLHelper.getXMLStreamReader(reader);
            StreamHelper.skipToStartElement(in);
            if (HEADER.equals(in.getName())) {
                StreamHelper.skipToNextStartElement(in);
            }
            return EPRHelper.fromXML(in);
        }
        catch (XMLStreamException xmlse) {
            throw new UnmarshalException("Unable to parse EPR XML.", xmlse);
        }
    }

    private static final void setSpecificEPR(EPR epr) {
        String eprType = null;
        if (epr instanceof InVMEpr) {
            eprType = InVMEpr.type().toString();
        } else if (epr instanceof EmailEpr) {
            eprType = EmailEpr.type().toString();
        } else if (epr instanceof FTPSEpr) {
            eprType = FTPSEpr.type().toString();
        } else if (epr instanceof SFTPEpr) {
            eprType = SFTPEpr.type().toString();
        } else if (epr instanceof HTTPEpr) {
            eprType = HTTPEpr.type().toString();
        } else if (epr instanceof JDBCEpr) {
            eprType = JDBCEpr.type().toString();
        } else if (epr instanceof HibernateEpr) {
            eprType = HibernateEpr.type().toString();
        } else if (epr instanceof JMSEpr) {
            eprType = JMSEpr.type().toString();
        } else if (epr instanceof FTPEpr) {
            eprType = FTPEpr.type().toString();
        } else if (epr instanceof FileEpr) {
            eprType = FileEpr.type().toString();
        } else if (epr instanceof LogicalEPR) {
            eprType = LogicalEPR.type().toString();
        }
        if (eprType != null && epr.getAddr().getExtensionValue(EPR_TYPE) == null) {
            epr.getAddr().addExtension(EPR_TYPE, eprType);
        }
    }

    public static final EPR getSpecificEPR(EPR epr) {
        String eprType = epr.getAddr().getExtensionValue(EPR_TYPE);
        if (eprType != null) {
            if (eprType.equals(InVMEpr.type().toString())) {
                return new InVMEpr(epr);
            }
            if (eprType.equals(EmailEpr.type().toString())) {
                return new EmailEpr(epr);
            }
            if (eprType.equals(FTPSEpr.type().toString())) {
                return new FTPSEpr(epr);
            }
            if (eprType.equals(SFTPEpr.type().toString())) {
                return new SFTPEpr(epr);
            }
            if (eprType.equals(HTTPEpr.type().toString())) {
                return new HTTPEpr(epr);
            }
            if (eprType.equals(JDBCEpr.type().toString())) {
                return new JDBCEpr(epr);
            }
            if (eprType.equals(HibernateEpr.type().toString())) {
                return new HibernateEpr(epr);
            }
            if (eprType.equals(JMSEpr.type().toString())) {
                return new JMSEpr(epr);
            }
            if (eprType.equals(FTPEpr.type().toString())) {
                return new FTPEpr(epr);
            }
            if (eprType.equals(FileEpr.type().toString())) {
                return new FileEpr(epr);
            }
            if (eprType.equals(LogicalEPR.type().toString())) {
                return new LogicalEPR(epr);
            }
            return epr;
        }
        return epr;
    }

    public static EPR copyEPR(EPR epr, List<PortReference.Extension> extensions) {
        EPR copyEPR = new EPR(epr.getAddr().copy());
        PortReference addr = copyEPR.getAddr();
        if (extensions != null) {
            for (PortReference.Extension extension : extensions) {
                if (EPR_TYPE.equals(extension.getTag()) && "http://schemas.jboss.com/ws/2007/01/jbossesb".equals(extension.getURI()) && "jbossesb".equals(extension.getPrefix())) continue;
                addr.addExtension(extension);
            }
        }
        return copyEPR;
    }
}

