/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.dependencies;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jboss.internal.soa.esb.dependencies.WSDeploymentBarrierControllerMBean;
import org.jboss.logging.Logger;
import org.jboss.system.ListenerServiceMBeanSupport;
import org.jboss.system.ServiceMBean;
import org.jboss.system.ServiceMBeanSupport;

public class WSDeploymentBarrierController
extends ListenerServiceMBeanSupport
implements WSDeploymentBarrierControllerMBean {
    private static final Logger logger = Logger.getLogger(WSDeploymentBarrierController.class);
    private ObjectName wsObjectName;
    private WSDeploymentBarrier wsDeploymentBarrier;

    public ObjectName getWsObjectName() {
        return this.wsObjectName;
    }

    public void setWsObjectName(ObjectName wsObjectName) {
        this.wsObjectName = wsObjectName;
    }

    protected void createService() throws Exception {
        ArrayList<ListenerServiceMBeanSupport.SubscriptionInfo> subscriptions = new ArrayList<ListenerServiceMBeanSupport.SubscriptionInfo>();
        ObjectName subObjectName = new ObjectName("jboss.web:service=WebServer");
        subscriptions.add(new ListenerServiceMBeanSupport.SubscriptionInfo(subObjectName, (Object)"WebServer", null));
        this.subscribe(subscriptions, true, this.getServiceName());
        this.registerExistingDeployment();
    }

    protected void destroyService() throws Exception {
        this.unsubscribe();
        if (this.wsDeploymentBarrier != null) {
            this.unregisterBarrierMBean(WSDeploymentBarrierController.toBarrierObjectName(this.wsObjectName));
        }
    }

    private void handle(Notification notification) {
        MBeanServerNotification mbServerNotification;
        if (notification instanceof MBeanServerNotification && (mbServerNotification = (MBeanServerNotification)notification).getMBeanName().equals(this.wsObjectName)) {
            ObjectName barrierObjectName;
            try {
                barrierObjectName = WSDeploymentBarrierController.toBarrierObjectName(this.wsObjectName);
            }
            catch (MalformedObjectNameException e) {
                logger.warn((Object)("Failed to create WS Deployment Barrier MBean ObjectName for WS deployment '" + this.wsObjectName + "'."), (Throwable)e);
                return;
            }
            if (notification.getType().equals("JMX.mbean.registered")) {
                this.registerBarrierMBean(barrierObjectName);
            } else if (notification.getType().equals("JMX.mbean.unregistered")) {
                this.unregisterBarrierMBean(barrierObjectName);
            }
        }
    }

    private void registerBarrierMBean(ObjectName barrierObjectName) {
        if (this.wsDeploymentBarrier != null) {
            return;
        }
        this.wsDeploymentBarrier = new WSDeploymentBarrier();
        try {
            this.getServer().registerMBean(this.wsDeploymentBarrier, barrierObjectName);
            this.wsDeploymentBarrier.create();
            this.wsDeploymentBarrier.start();
            logger.debug((Object)("Registered WS Barrier: " + barrierObjectName));
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to register WS Deployment Barrier MBean.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterBarrierMBean(ObjectName barrierObjectName) {
        if (this.wsDeploymentBarrier == null) {
            return;
        }
        try {
            this.wsDeploymentBarrier.stop();
            this.wsDeploymentBarrier.destroy();
            this.getServer().unregisterMBean(barrierObjectName);
            logger.debug((Object)("Unregistered WS Barrier: " + barrierObjectName));
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to unregister WS Deployment Barrier MBean.", (Throwable)e);
        }
        finally {
            this.wsDeploymentBarrier = null;
        }
    }

    private void registerExistingDeployment() {
        try {
            Set<ObjectInstance> existingDeployments = this.getServer().queryMBeans(this.wsObjectName, null);
            if (existingDeployments != null && !existingDeployments.isEmpty()) {
                this.registerBarrierMBean(WSDeploymentBarrierController.toBarrierObjectName(this.wsObjectName));
            }
        }
        catch (MalformedObjectNameException e) {
            logger.warn((Object)"Failed to query existance of WS Barrier Object.", (Throwable)e);
        }
    }

    private static ObjectName toBarrierObjectName(ObjectName wsName) throws MalformedObjectNameException {
        return new ObjectName(wsName.getCanonicalName() + ".Barrier");
    }

    public void handleNotification(Notification notification, Object handback) {
        this.handle(notification);
        super.handleNotification(notification, handback);
    }

    public void handleNotification2(Notification notification, Object handback) {
        this.handle(notification);
        super.handleNotification2(notification, handback);
    }

    public static class WSDeploymentBarrier
    extends ServiceMBeanSupport
    implements WSDeploymentBarrierMBean {
    }

    public static interface WSDeploymentBarrierMBean
    extends ServiceMBean {
    }
}

