/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.model.ModelAdapter;
import org.jboss.soa.esb.listeners.config.model.ModelException;
import org.jboss.soa.esb.listeners.config.model.ModelParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Generator {
    private static Logger logger = Logger.getLogger(Generator.class);
    public static final String ESB_CONFIG_GATEWAY_XML_FILE = "jbossesb-gateway.xml";
    public static final String ESB_CONFIG_XML_FILE = "jbossesb-listener.xml";
    private ModelAdapter model;
    private OutputStream gatewayOutputStream;
    private OutputStream listenerOutputStream;

    public Generator(InputStream config, OutputStream listenerOutputStream, OutputStream gatewayOutputStream) throws ConfigurationException, IOException {
        this(config);
        this.gatewayOutputStream = gatewayOutputStream;
        this.listenerOutputStream = listenerOutputStream;
    }

    public Generator(InputStream config) throws ConfigurationException, IOException {
        if (config == null) {
            throw new IllegalArgumentException("null 'config' arg in constructor call.");
        }
        this.model = Generator.parseConfig(config);
        this.model.verifyScheduleProviderConfig();
    }

    public static ModelAdapter parseConfig(InputStream config) throws IOException, ConfigurationException {
        try {
            return ModelParser.getParser().parse(new InputStreamReader(config));
        }
        catch (ModelException me) {
            throw new ConfigurationException("Error while processing ESB Listener configuration stream.", me);
        }
    }

    public void generate() throws ConfigurationException {
        Document awareConfig = this.model.generateESBAwareConfig();
        YADOMUtil.serialize((Node)awareConfig, this.listenerOutputStream);
        Document gatewayConfig = this.model.generateGatewayConfig();
        YADOMUtil.serialize((Node)gatewayConfig, this.gatewayOutputStream);
    }

    public void generate(File outdir) throws ConfigurationException {
        if (outdir == null) {
            throw new IllegalArgumentException("null 'outdir' arg in method call.");
        }
        if (!outdir.exists()) {
            outdir.mkdirs();
            if (!outdir.exists()) {
                throw new IllegalArgumentException("Failed to create 'outdir' [" + outdir.getAbsolutePath() + "].");
            }
        }
        if (!outdir.isDirectory()) {
            throw new IllegalArgumentException("'outdir' exists, but is not a directory.");
        }
        Document awareConfig = this.model.generateESBAwareConfig();
        logger.info((Object)("Serializing ESB Aware Listener 'ConfigTree' configuration to [" + new File(outdir, ESB_CONFIG_XML_FILE).getAbsolutePath() + "]."));
        YADOMUtil.serialize((Node)awareConfig, outdir, ESB_CONFIG_XML_FILE);
        Document gatewayConfig = this.model.generateGatewayConfig();
        logger.info((Object)("Serializing ESB Gateway 'ConfigTree' configuration to [" + new File(outdir, ESB_CONFIG_GATEWAY_XML_FILE).getAbsolutePath() + "]."));
        YADOMUtil.serialize((Node)gatewayConfig, outdir, ESB_CONFIG_GATEWAY_XML_FILE);
    }

    public ModelAdapter getModel() {
        return this.model;
    }
}

