/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.listeners.config.XmlValidator;
import org.jboss.soa.esb.listeners.config.XmlValidatorException;
import org.jboss.soa.esb.util.ClassUtil;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlValidatorImpl
implements XmlValidator {
    private Logger log = Logger.getLogger(this.getClass());
    private String defaultSchema = "etc/schemas/xml/jbossesb-1.0.1.xsd";
    private boolean isValid = true;
    private Collection<String> validationResults = new HashSet<String>();
    private Document xmlDocument;

    public XmlValidatorImpl() {
        File defaultSchemaFile = new File(this.defaultSchema);
        if (defaultSchemaFile.exists()) {
            this.log.debug((Object)("defaultSchema " + this.defaultSchema + " exists"));
        }
    }

    public XmlValidatorImpl(InputSource xmlSource) {
        this.setXMLDocument(xmlSource);
        File defaultSchemaFile = new File(this.defaultSchema);
        if (defaultSchemaFile.exists()) {
            this.log.debug((Object)("defaultSchema " + this.defaultSchema + " exists"));
        }
    }

    @Override
    public boolean validate(InputSource xmlSource) throws XmlValidatorException {
        StreamSource validationInputSource = null;
        InputStream validationInputStream = ClassUtil.getResourceAsStream(this.defaultSchema, this.getClass());
        if (validationInputStream == null) {
            File validationFile = new File(this.defaultSchema);
            this.log.debug((Object)("Validation file " + this.defaultSchema + " exists?:" + validationFile.exists()));
            try {
                validationInputStream = new FileInputStream(validationFile);
            }
            catch (FileNotFoundException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (validationInputStream == null) {
            this.log.warn((Object)("Could not obtain validation file " + this.defaultSchema));
        } else {
            this.log.debug((Object)("Reading validation info from " + this.defaultSchema));
            validationInputSource = new StreamSource(validationInputStream);
        }
        return this.validate(xmlSource, validationInputSource);
    }

    @Override
    public boolean validate(InputSource xmlSource, StreamSource validationSource) throws XmlValidatorException {
        try {
            Schema schema = null;
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            if (validationSource == null) {
                StreamSource schemaFile = new StreamSource(this.defaultSchema);
                try {
                    schema = factory.newSchema(schemaFile);
                }
                catch (SAXException e) {
                    this.log.error((Object)("Failed to validate xml: " + e));
                    this.isValid = false;
                }
            } else {
                schema = factory.newSchema(validationSource);
            }
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            builderFactory.setSchema(schema);
            DocumentBuilder parser = null;
            try {
                parser = builderFactory.newDocumentBuilder();
                parser.setErrorHandler(new XmlErrorHandler());
            }
            catch (ParserConfigurationException e) {
                this.log.error((Object)("ParserConfigurationException occurred: " + e.getMessage()), (Throwable)e);
                this.isValid = false;
            }
            try {
                this.xmlDocument = parser.parse(xmlSource);
            }
            catch (IOException e) {
                this.log.error((Object)("parser.parse(): IOException occurred: " + e.getMessage()), (Throwable)e);
                this.isValid = false;
            }
        }
        catch (SAXException e) {
            this.log.error((Object)("SAXException occurred: " + e.getMessage()));
            this.isValid = false;
        }
        return this.isValid;
    }

    @Override
    public Collection<String> getValidationResults() {
        return this.validationResults;
    }

    public void setXMLDocument(InputSource xmlSource) {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = builderFactory.newDocumentBuilder();
            this.xmlDocument = parser.parse(xmlSource);
            this.log.info((Object)this.xmlDocument.toString());
        }
        catch (SAXException e) {
            this.log.error((Object)e.getMessage());
        }
        catch (ParserConfigurationException e) {
            this.log.error((Object)e.getMessage());
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage());
        }
    }

    @Override
    public Document getXMLDocument() {
        return this.xmlDocument;
    }

    class XmlErrorHandler
    implements ErrorHandler {
        XmlErrorHandler() {
        }

        public void warning(SAXParseException exception) throws SAXException {
            XmlValidatorImpl.this.validationResults.add("WARNING-" + exception.getSystemId() + "-" + exception.getLineNumber() + ":" + exception.getMessage());
            XmlValidatorImpl.this.log.warn((Object)("WARNING-" + exception.getSystemId() + "-" + exception.getLineNumber() + ":" + exception.getMessage()));
        }

        public void error(SAXParseException exception) throws SAXException {
            XmlValidatorImpl.this.validationResults.add("ERROR-" + exception.getSystemId() + "-" + exception.getLineNumber() + ":" + exception.getMessage());
            XmlValidatorImpl.this.log.error((Object)(XmlValidatorImpl.this.validationResults.size() + "-ERROR-" + exception.getSystemId() + "-" + exception.getLineNumber() + ":" + exception.getMessage()));
            XmlValidatorImpl.this.isValid = false;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            XmlValidatorImpl.this.validationResults.add("FATAL-" + exception.getSystemId() + "-" + exception.getLineNumber() + ":" + exception.getMessage());
            XmlValidatorImpl.this.log.fatal((Object)("FATAL-" + exception.getSystemId() + "-" + exception.getLineNumber() + ":" + exception.getMessage()));
            XmlValidatorImpl.this.isValid = false;
        }
    }
}

