/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.jca;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.filter.FilterManager;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerUtil;
import org.jboss.soa.esb.listeners.RegistryUtil;
import org.jboss.soa.esb.listeners.jca.BaseJcaInflow;
import org.jboss.soa.esb.listeners.jca.InflowMessageProcessor;
import org.jboss.soa.esb.listeners.jca.InflowMessageProcessorAdapter;
import org.jboss.soa.esb.listeners.jca.JcaGatewayException;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.util.ClassUtil;
import org.jboss.soa.esb.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcaGatewayListener
extends BaseJcaInflow<InflowMessageProcessorAdapter>
implements InflowMessageProcessor {
    private final String targetServiceCategory;
    private final String targetServiceName;
    private final String serviceCategory;
    private final String serviceName;
    private final EPR serviceEPR;
    private final Object composer;
    private final Method processMethod;
    private ServiceInvoker serviceInvoker;

    public JcaGatewayListener(ConfigTree config) throws ConfigurationException {
        super(config, InflowMessageProcessorAdapter.class);
        Class composerClass;
        this.targetServiceCategory = ListenerUtil.getValue(config, "target-service-category");
        if (Util.isNullString(this.targetServiceCategory)) {
            throw new ConfigurationException("No service category defined!");
        }
        this.targetServiceName = ListenerUtil.getValue(config, "target-service-name");
        if (Util.isNullString(this.targetServiceName)) {
            throw new ConfigurationException("No service name defined!");
        }
        this.serviceCategory = ListenerUtil.getValue(config, "service-category");
        this.serviceName = ListenerUtil.getValue(config, "service-name");
        this.serviceEPR = this.serviceName != null ? ListenerUtil.assembleEpr(config) : null;
        String composerName = config.getAttribute("composer-class");
        if (Util.isNullString(composerName)) {
            throw new ConfigurationException("No composer class defined");
        }
        try {
            composerClass = ClassUtil.forName(composerName, this.getClass());
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConfigurationException("Could not load composer class: " + composerName, cnfe);
        }
        try {
            Object composer;
            try {
                Constructor configConstructor = composerClass.getConstructor(ConfigTree.class);
                composer = configConstructor.newInstance(config);
            }
            catch (NoSuchMethodException nsme) {
                composer = composerClass.newInstance();
            }
            this.composer = composer;
        }
        catch (Throwable th) {
            throw new ConfigurationException("Unexpected error instantiating composer: " + composerName, th);
        }
        String processMethodName = config.getAttribute("composer-process");
        try {
            this.processMethod = composerClass.getMethod(processMethodName, Object.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new ConfigurationException("Could not locate process method: " + processMethodName, nsme);
        }
    }

    @Override
    protected String getDescription() {
        return "targetCategory: " + this.targetServiceCategory + " targetService: " + this.targetServiceName;
    }

    @Override
    protected void doInitialise() throws ManagedLifecycleException {
        super.doInitialise();
        ((InflowMessageProcessorAdapter)this.bean).setInflowMessageProcessor(this);
        try {
            this.serviceInvoker = new ServiceInvoker(this.targetServiceCategory, this.targetServiceName);
        }
        catch (MessageDeliverException mde) {
            throw new ManagedLifecycleException("Unexpected exception creating service invoker", mde);
        }
        if (this.serviceEPR != null) {
            try {
                RegistryUtil.register(this.getConfig(), this.serviceEPR);
            }
            catch (RegistryException re) {
                throw new ManagedLifecycleException("Unexpected exception while registering service", re);
            }
        }
    }

    @Override
    protected void doDestroy() throws ManagedLifecycleException {
        super.doDestroy();
        if (this.serviceEPR != null) {
            RegistryUtil.unregister(this.serviceCategory, this.serviceName, this.serviceEPR);
        }
    }

    @Override
    public void process(Object messageIn) {
        try {
            Message messageOut = (Message)this.processMethod.invoke(this.composer, messageIn);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("org.jboss.soa.esb.gateway.config", this.getConfig());
            messageOut = FilterManager.getInstance().doOutputWork(messageOut, params);
            this.serviceInvoker.deliverAsync(messageOut);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Error err) {
            throw err;
        }
        catch (Throwable th) {
            throw new JcaGatewayException("Unexpected exception caught while processing JCA message", th);
        }
    }
}

