/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.message.errors;

import java.net.URI;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.couriers.FaultMessageException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;

public class Factory {
    public static final String ERROR_ATTRIBUTE = "org.jboss.soa.esb.listeners.message.errors";
    public static final String PROCESSING_ERROR = "urn:action/error/actionprocessingerror";
    public static final String UNEXPECTED_ERROR = "urn:action/error/unexpectederror";
    public static final String NOT_ENABLED = "urn:action/error/disabled";
    public static final String VALIDATION_FAILURE = "urn:action/error/validationFailure";
    private static final Logger _logger = Logger.getLogger(Factory.class);

    public static void createExceptionFromFault(Message msg) throws FaultMessageException {
        String reason = msg.getFault().getReason();
        URI code = msg.getFault().getCode();
        Throwable cause = msg.getFault().getCause();
        if (cause == null) {
            throw new FaultMessageException(reason, code, msg);
        }
        throw new FaultMessageException(reason, code, msg, cause);
    }

    public static Message createErrorMessage(String type, Message input, Throwable problem) {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        Message errorMessage = MessageFactory.getInstance().getMessage(input.getType());
        if (errorMessage == null) {
            throw new IllegalArgumentException("Could not create error message from " + input.getType());
        }
        if (Factory.modifyMessage(input, errorMessage)) {
            errorMessage.getBody().add("org.jboss.soa.esb.message.fault.throwable", problem);
            try {
                errorMessage.getFault().setCode(new URI(type));
                if (problem != null) {
                    errorMessage.getFault().setReason(problem.toString());
                }
            }
            catch (Exception ex) {
                _logger.debug((Object)("Caught exception " + ex + " during message creation!"));
                return null;
            }
            return errorMessage;
        }
        return input;
    }

    private static final boolean modifyMessage(Message input, Message errorMessage) {
        EPR destination = input.getHeader().getCall().getFaultTo();
        if (destination == null && input.getHeader().getCall().getReplyTo() != null) {
            destination = input.getHeader().getCall().getReplyTo();
        }
        if (destination == null && input.getHeader().getCall().getFrom() != null) {
            destination = input.getHeader().getCall().getFrom();
        }
        if (destination != null) {
            errorMessage.getHeader().getCall().setTo(destination);
            if (input.getHeader().getCall().getMessageID() != null) {
                errorMessage.getHeader().getCall().setRelatesTo(input.getHeader().getCall().getMessageID());
            }
            return true;
        }
        return false;
    }
}

