/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.notification;

import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.rosetta.pooling.ConnectionException;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPool;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPoolContainer;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.message.format.MessageType;
import org.jboss.soa.esb.notification.NotificationException;
import org.jboss.soa.esb.notification.NotificationTarget;
import org.jboss.soa.esb.notification.NotifyUtil;
import org.jboss.soa.esb.notification.jms.DefaultJMSPropertiesSetter;
import org.jboss.soa.esb.notification.jms.JMSPropertiesSetter;
import org.jboss.soa.esb.util.JndiUtil;

public abstract class NotifyJMS
extends NotificationTarget {
    protected Logger log = Logger.getLogger(this.getClass());
    public static final String CONNECTION_FACTORY = "ConnectionFactory";
    private JMSPropertiesSetter jmsPropertiesStrategy = new DefaultJMSPropertiesSetter();
    private MessagePayloadProxy payloadProxy;
    public static final String CHILD_MSG_PROP = "messageProp";
    public static final String ATT_PROP_NAME = "name";
    public static final String ATT_PROP_VALUE = "value";
    public static final String ATT_DEST_NAME = "jndiName";
    public static final String PERSISTENT_ATTR = "persistent";
    public static final String PRIORITY_ATTR = "priority";
    public static final String TIME_TO_LIVE_ATTR = "time-to-live";
    private Properties m_oProps = new Properties();
    protected JmsConnectionPool[] connectionPools;
    protected Session[] sessions;
    protected MessageProducer[] producers;
    protected int[] deliveryModes;
    protected int[] priorities;
    protected long[] timeToLives;
    private Properties environment;

    protected abstract void send(javax.jms.Message var1, MessageProducer var2) throws JMSException;

    protected abstract MessageProducer createProducer(JmsConnectionPool var1, String var2, Session var3, Properties var4) throws NamingException, JMSException, ConnectionException;

    protected NotifyJMS(ConfigTree p_oP) throws ConfigurationException {
        super(p_oP);
        ConfigTree[] oaMsgP = p_oP.getChildren(CHILD_MSG_PROP);
        for (int i1 = 0; i1 < oaMsgP.length; ++i1) {
            String sVal;
            String sKey = oaMsgP[i1].getAttribute(ATT_PROP_NAME);
            if (null == sKey || null == (sVal = oaMsgP[i1].getAttribute(ATT_PROP_VALUE))) continue;
            this.m_oProps.setProperty(sKey.trim(), sVal);
        }
        this.payloadProxy = new MessagePayloadProxy(p_oP, new String[]{"org.jboss.soa.esb.message.content.bytes"}, new String[]{"org.jboss.soa.esb.message.content.bytes"});
        this.payloadProxy.setNullGetPayloadHandling(MessagePayloadProxy.NullPayloadHandling.LOG);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendNotification(Message esbMessage) throws NotificationException {
        NativeMessage defaultType = MessageType.JAVA_SERIALIZED.equals(esbMessage.getType()) ? NativeMessage.object : NativeMessage.text;
        try {
            ObjectMessage jmsMessage = null;
            Object obj = this.payloadProxy.getPayload(esbMessage);
            NativeMessage type = (NativeMessage)((Object)esbMessage.getProperties().getProperty("org.jboss.soa.esb.message.transport.jms.nativeMessageType", (Object)defaultType));
            if (type == NativeMessage.object) {
                if (obj == null) {
                    jmsMessage = this.sessions[0].createObjectMessage(null);
                } else {
                    if (!(obj instanceof byte[])) throw new NotificationException("Expected payload type for '" + esbMessage.getType() + "' is byte[].  Received '" + obj.getClass().getName() + "'.");
                    jmsMessage = this.sessions[0].createObjectMessage((Serializable)((byte[])obj));
                }
            } else {
                String content = null;
                if (obj instanceof byte[]) {
                    content = new String((byte[])obj);
                } else if (obj != null) {
                    content = obj.toString();
                }
                jmsMessage = this.sessions[0].createTextMessage(content);
            }
            this.setJMSProperties(esbMessage, (javax.jms.Message)jmsMessage);
            this.setJMSReplyTo((javax.jms.Message)jmsMessage, esbMessage);
            for (String string : this.m_oProps.keySet()) {
                String sVal = this.m_oProps.getProperty(string);
                jmsMessage.setStringProperty(string, sVal);
            }
            this.sendToAll((javax.jms.Message)jmsMessage);
            return;
        }
        catch (JMSException ex) {
            throw new NotificationException(ex);
        }
        catch (MessageDeliverException e) {
            throw new NotificationException(e);
        }
        finally {
            if (this.connectionPools != null) {
                this.connectionPools[0].closeSession(this.sessions[0]);
            }
        }
    }

    protected void setJMSProperties(Message fromESBMessage, javax.jms.Message toJMSMessage) throws JMSException {
        this.jmsPropertiesStrategy.setJMSProperties(fromESBMessage, toJMSMessage);
    }

    void setJMSReplyTo(javax.jms.Message jmsMessage, Message esbMessage) throws NotificationException {
        Destination destination = (Destination)esbMessage.getProperties().getProperty("javax.jms.message.replyTo");
        if (destination != null) {
            try {
                jmsMessage.setJMSReplyTo(destination);
            }
            catch (JMSException e) {
                throw new NotificationException("Could not set the JMSReplyTo to destination [" + destination + "]", e);
            }
        }
    }

    protected void sendToAll(javax.jms.Message p_oMsg) throws JMSException {
        StringBuilder jmsExceptions = new StringBuilder();
        for (int i1 = 0; i1 < this.producers.length; ++i1) {
            try {
                this.send(p_oMsg, this.producers[i1]);
                continue;
            }
            catch (JMSException e) {
                String msg = "[JMSException while sending to : " + this.producers[i1].getDestination();
                this.log.error((Object)msg, (Throwable)e);
                jmsExceptions.append(NotifyUtil.createExceptionErrorString(msg, (Exception)((Object)e)));
            }
        }
        if (jmsExceptions.length() > 0) {
            throw new JMSException(jmsExceptions.toString());
        }
    }

    protected void setUpProducers(ConfigTree[] configTrees) throws ConfigurationException, JMSException, ConnectionException {
        int nrQueuesOrTopics = configTrees.length;
        this.producers = new MessageProducer[nrQueuesOrTopics];
        this.connectionPools = new JmsConnectionPool[nrQueuesOrTopics];
        this.sessions = new Session[nrQueuesOrTopics];
        this.deliveryModes = new int[nrQueuesOrTopics];
        this.priorities = new int[nrQueuesOrTopics];
        this.timeToLives = new long[nrQueuesOrTopics];
        try {
            for (int i = 0; i < nrQueuesOrTopics; ++i) {
                String prefix;
                String contextFactory;
                this.environment = new Properties();
                String sAtt = configTrees[i].getAttribute(ATT_DEST_NAME);
                if (null == sAtt) {
                    throw new ConfigurationException("Missing attribute 'jndiName");
                }
                String jndiURL = configTrees[i].getAttribute("jndi-URL");
                if (jndiURL != null) {
                    this.environment.setProperty("java.naming.provider.url", jndiURL);
                }
                if ((contextFactory = configTrees[i].getAttribute("jndi-context-factory")) != null) {
                    this.environment.setProperty("java.naming.factory.initial", contextFactory);
                }
                if ((prefix = configTrees[i].getAttribute("jndi-pkg-prefix")) != null) {
                    this.environment.setProperty("java.naming.factory.url.pkgs", prefix);
                }
                List<KeyValuePair> properties = configTrees[i].childPropertyList();
                String[] jndiPrefixes = JndiUtil.getJndiPrefixes(KeyValuePair.getValue("jndi-prefixes", properties));
                block3: for (KeyValuePair property : properties) {
                    for (String jndiPrefix : jndiPrefixes) {
                        if (!property.getKey().startsWith(jndiPrefix)) continue;
                        this.environment.setProperty(property.getKey(), property.getValue());
                        continue block3;
                    }
                }
                String connectionFactory = configTrees[i].getAttribute("connection-factory", CONNECTION_FACTORY);
                this.connectionPools[i] = JmsConnectionPoolContainer.getPool(this.environment, connectionFactory);
                this.sessions[i] = this.connectionPools[i].getSession();
                this.producers[i] = this.createProducer(this.connectionPools[i], sAtt, this.sessions[i], this.environment);
                String persistentStr = configTrees[i].getAttribute(PERSISTENT_ATTR, "true");
                this.deliveryModes[i] = persistentStr.equalsIgnoreCase("true") ? 2 : 1;
                String priorityStr = configTrees[i].getAttribute(PRIORITY_ATTR);
                this.priorities[i] = priorityStr == null ? 4 : Integer.parseInt(priorityStr);
                String ttlStr = configTrees[i].getAttribute(TIME_TO_LIVE_ATTR);
                this.timeToLives[i] = ttlStr == null ? 0L : Long.parseLong(ttlStr);
                this.producers[i].setDeliveryMode(this.deliveryModes[i]);
                this.producers[i].setPriority(this.priorities[i]);
                this.producers[i].setTimeToLive(this.timeToLives[i]);
            }
        }
        catch (NamingException ex) {
            throw new ConfigurationException(ex);
        }
    }

    public void setJmsPropertiesStrategy(JMSPropertiesSetter jmsPropertiesStrategy) {
        this.jmsPropertiesStrategy = jmsPropertiesStrategy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NativeMessage {
        text,
        object;

    }
}

