/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security.auth.ws;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashSet;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.soa.esb.lifecycle.LifecycleResourceException;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequestImpl;
import org.jboss.soa.esb.services.security.auth.SecurityInfoExtractor;
import org.jboss.soa.esb.services.security.auth.ws.BinarySecurityToken;
import org.jboss.soa.esb.services.security.auth.ws.UsernameToken;
import org.jboss.soa.esb.services.security.principals.User;
import org.jboss.soa.esb.smooks.resource.SmooksResource;
import org.jboss.soa.esb.util.ClassUtil;
import org.milyn.Smooks;
import org.milyn.payload.JavaResult;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSecurityInfoExtractor
implements SecurityInfoExtractor<String> {
    private static final String SMOOK_CONFIG_FILE = "smooks-ws-security.xml";
    private Smooks smooks;

    public WSSecurityInfoExtractor() {
        this.createSmooks(SMOOK_CONFIG_FILE);
    }

    public WSSecurityInfoExtractor(String configFile) {
        this.createSmooks(configFile);
    }

    @Override
    public AuthenticationRequest extractSecurityInfo(String soap) {
        BinarySecurityToken binaryToken;
        if (soap == null || !soap.startsWith("<")) {
            return null;
        }
        JavaResult javaResult = new JavaResult();
        this.smooks.filterSource((Source)new StreamSource(new StringReader(soap)), new Result[]{javaResult});
        UsernameToken token = (UsernameToken)javaResult.getBean("userNameToken");
        User user = null;
        HashSet<Object> credentials = new HashSet<Object>();
        if (token != null) {
            user = new User(token.getUserName());
            credentials.add(token.getPassword());
        }
        if ((binaryToken = (BinarySecurityToken)javaResult.getBean("binarySecurityToken")) != null) {
            credentials.add(binaryToken.getKey());
        }
        if (credentials.isEmpty()) {
            return null;
        }
        return new AuthenticationRequestImpl.Builder(user, credentials).build();
    }

    private void createSmooks(String configFile) {
        InputStream is = ClassUtil.getResourceAsStream(configFile, this.getClass());
        if (is == null) {
            throw new IllegalArgumentException("Failed to located configuration file resource: " + configFile);
        }
        try {
            this.smooks = SmooksResource.createSmooksResource(is);
        }
        catch (LifecycleResourceException lre) {
            throw new IllegalStateException("Could not parse " + configFile, lre);
        }
        catch (SAXException e) {
            throw new IllegalStateException("Could not parse " + configFile, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not parse " + configFile, e);
        }
    }
}

