/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.util.HasLatestStrategy;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;

public class ChainResolver
extends AbstractResolver {
    private boolean returnFirst = false;
    private List chain = new ArrayList();
    private boolean dual;
    private Boolean checkmodified = null;

    public void add(DependencyResolver resolver) {
        this.chain.add(resolver);
    }

    public boolean isCheckmodified() {
        if (this.checkmodified == null) {
            if (this.getSettings() != null) {
                String check = this.getSettings().getVariable("ivy.resolver.default.check.modified");
                return check != null ? Boolean.valueOf(check) : false;
            }
            return false;
        }
        return this.checkmodified;
    }

    public void setCheckmodified(boolean check) {
        this.checkmodified = check;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data) throws ParseException {
        data = new ResolveData(data, this.doValidate(data));
        ResolvedModuleRevision ret = null;
        ArrayList<Exception> errors = new ArrayList<Exception>();
        ResolvedModuleRevision mr = null;
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        Message.verbose(this.getName() + ": Checking cache for: " + dd);
        mr = this.findModuleInCache(dd, this.getCacheOptions(data), true);
        if (mr != null) {
            Message.verbose(this.getName() + ": module revision found in cache: " + mr.getId());
            return this.resolvedRevision(mr);
        }
        boolean isDynamic = this.getSettings().getVersionMatcher().isDynamic(mrid);
        Iterator iter = this.chain.iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            LatestStrategy oldLatest = this.setLatestIfRequired(resolver, this.getLatestStrategy());
            try {
                mr = resolver.getDependency(dd, data);
            }
            catch (Exception ex) {
                Message.verbose("problem occured while resolving " + dd + " with " + resolver + ": " + StringUtils.getStackTrace(ex));
                errors.add(ex);
            }
            finally {
                if (oldLatest != null) {
                    ChainResolver.setLatest(resolver, oldLatest);
                }
            }
            this.checkInterrupted();
            if (mr == null) continue;
            boolean shouldReturn = this.returnFirst;
            if (!(shouldReturn |= !isDynamic && ret != null && !ret.getDescriptor().isDefault())) {
                String mrDesc = mr.getId() + (mr.getDescriptor().isDefault() ? "[default]" : "") + " from " + mr.getResolver().getName();
                Message.debug("\tchecking " + mrDesc + " against " + ret);
                if (ret == null) {
                    Message.debug("\tmodule revision kept as first found: " + mrDesc);
                    ret = mr;
                } else if (this.isAfter(mr, ret, data.getDate())) {
                    Message.debug("\tmodule revision kept as younger: " + mrDesc);
                    ret = mr;
                } else if (!mr.getDescriptor().isDefault() && ret.getDescriptor().isDefault()) {
                    Message.debug("\tmodule revision kept as better (not default): " + mrDesc);
                    ret = mr;
                } else {
                    Message.debug("\tmodule revision discarded as older: " + mrDesc);
                }
                if (isDynamic || ret.getDescriptor().isDefault()) continue;
                Message.debug("\tmodule revision found and is not default: returning " + mrDesc);
                return this.resolvedRevision(mr);
            }
            return this.resolvedRevision(mr);
        }
        if (ret == null && !errors.isEmpty()) {
            if (errors.size() == 1) {
                Exception ex = (Exception)errors.get(0);
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                if (ex instanceof ParseException) {
                    throw (ParseException)ex;
                }
                throw new RuntimeException(ex.toString(), ex);
            }
            StringBuffer err = new StringBuffer();
            Iterator iter2 = errors.iterator();
            while (iter2.hasNext()) {
                Exception ex = (Exception)iter2.next();
                err.append("\t").append(StringUtils.getErrorMessage(ex)).append("\n");
            }
            err.setLength(err.length() - 1);
            throw new RuntimeException("several problems occured while resolving " + dd + ":\n" + err);
        }
        return this.resolvedRevision(ret);
    }

    private ResolvedModuleRevision resolvedRevision(ResolvedModuleRevision mr) {
        if (this.isDual() && mr != null) {
            return new ResolvedModuleRevision(mr.getResolver(), this, mr.getDescriptor(), mr.getReport());
        }
        return mr;
    }

    private LatestStrategy setLatestIfRequired(DependencyResolver resolver, LatestStrategy latestStrategy) {
        String latestName = ChainResolver.getLatestStrategyName(resolver);
        if (latestName != null && !"default".equals(latestName)) {
            LatestStrategy oldLatest = ChainResolver.getLatest(resolver);
            ChainResolver.setLatest(resolver, latestStrategy);
            return oldLatest;
        }
        return null;
    }

    private boolean isAfter(ResolvedModuleRevision rmr1, ResolvedModuleRevision rmr2, Date date) {
        ArtifactInfo[] ais = new ArtifactInfo[]{new ResolvedModuleRevisionArtifactInfo(rmr2), new ResolvedModuleRevisionArtifactInfo(rmr1)};
        return this.getLatestStrategy().findLatest(ais, date) != ais[0];
    }

    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        Iterator iter = this.chain.iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            ResolvedResource result = resolver.findIvyFileRef(dd, data);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void reportFailure() {
        Iterator iter = this.chain.iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            resolver.reportFailure();
        }
    }

    public void reportFailure(Artifact art) {
        Iterator iter = this.chain.iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            resolver.reportFailure(art);
        }
    }

    public DownloadReport download(Artifact[] artifacts, DownloadOptions options) {
        ArrayList<Artifact> artifactsToDownload = new ArrayList<Artifact>(Arrays.asList(artifacts));
        DownloadReport report = new DownloadReport();
        Iterator iter = this.chain.iterator();
        while (iter.hasNext() && !artifactsToDownload.isEmpty()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            DownloadReport r = resolver.download(artifactsToDownload.toArray(new Artifact[artifactsToDownload.size()]), options);
            ArtifactDownloadReport[] adr = r.getArtifactsReports();
            for (int i = 0; i < adr.length; ++i) {
                if (adr[i].getDownloadStatus() == DownloadStatus.FAILED) continue;
                artifactsToDownload.remove(adr[i].getArtifact());
                report.addArtifactReport(adr[i]);
            }
        }
        iter = artifactsToDownload.iterator();
        while (iter.hasNext()) {
            Artifact art = (Artifact)iter.next();
            ArtifactDownloadReport adr = new ArtifactDownloadReport(art);
            adr.setDownloadStatus(DownloadStatus.FAILED);
            report.addArtifactReport(adr);
        }
        return report;
    }

    public List getResolvers() {
        return this.chain;
    }

    public void publish(Artifact artifact, File src, boolean overwrite) throws IOException {
        this.getFirstResolver().publish(artifact, src, overwrite);
    }

    public void abortPublishTransaction() throws IOException {
        this.getFirstResolver().abortPublishTransaction();
    }

    public void beginPublishTransaction(ModuleRevisionId module, boolean overwrite) throws IOException {
        this.getFirstResolver().beginPublishTransaction(module, overwrite);
    }

    public void commitPublishTransaction() throws IOException {
        this.getFirstResolver().commitPublishTransaction();
    }

    private DependencyResolver getFirstResolver() {
        if (this.chain.isEmpty()) {
            throw new IllegalStateException("invalid chain resolver with no sub resolver");
        }
        return (DependencyResolver)this.chain.get(0);
    }

    public boolean isReturnFirst() {
        return this.returnFirst;
    }

    public void setReturnFirst(boolean returnFirst) {
        this.returnFirst = returnFirst;
    }

    public void dumpSettings() {
        Message.verbose("\t" + this.getName() + " [chain] " + this.chain);
        Message.debug("\t\treturn first: " + this.isReturnFirst());
        Message.debug("\t\tdual: " + this.isDual());
        Iterator iter = this.chain.iterator();
        while (iter.hasNext()) {
            DependencyResolver r = (DependencyResolver)iter.next();
            Message.debug("\t\t-> " + r.getName());
        }
    }

    public boolean exists(Artifact artifact) {
        Iterator iter = this.chain.iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            if (!resolver.exists(artifact)) continue;
            return true;
        }
        return false;
    }

    private static void setLatest(DependencyResolver resolver, LatestStrategy latest) {
        if (resolver instanceof HasLatestStrategy) {
            HasLatestStrategy r = (HasLatestStrategy)((Object)resolver);
            r.setLatestStrategy(latest);
        }
    }

    private static LatestStrategy getLatest(DependencyResolver resolver) {
        if (resolver instanceof HasLatestStrategy) {
            HasLatestStrategy r = (HasLatestStrategy)((Object)resolver);
            return r.getLatestStrategy();
        }
        return null;
    }

    private static String getLatestStrategyName(DependencyResolver resolver) {
        if (resolver instanceof HasLatestStrategy) {
            HasLatestStrategy r = (HasLatestStrategy)((Object)resolver);
            return r.getLatest();
        }
        return null;
    }

    public void setDual(boolean b) {
        this.dual = b;
    }

    public boolean isDual() {
        return this.dual;
    }

    public static class ResolvedModuleRevisionArtifactInfo
    implements ArtifactInfo {
        private ResolvedModuleRevision rmr;

        public ResolvedModuleRevisionArtifactInfo(ResolvedModuleRevision rmr) {
            this.rmr = rmr;
        }

        public String getRevision() {
            return this.rmr.getId().getRevision();
        }

        public long getLastModified() {
            return this.rmr.getPublicationDate().getTime();
        }
    }
}

