UPDATE ODE_SCHEMA_VERSION SET VERSION = 220;

DROP TABLE ODE_JOB;

CREATE TABLE ODE_JOB (
  jobid VARCHAR2(64)  NOT NULL,
  ts number(19,0)  NOT NULL,
  nodeid varchar2(64),
  scheduled number(1,0)  NOT NULL,
  transacted number(1,0)  NOT NULL,
  
  instanceId number(37),
  mexId varchar(255),
  processId varchar2(255),
  type varchar2(255),
  channel varchar2(255),
  correlatorId varchar2(255),
  correlationKeySet varchar2(255),
  retryCount number(10,0),
  inMem number(1,0),
  detailsExt blob,

  PRIMARY KEY(jobid));

CREATE INDEX IDX_ODE_JOB_TS ON ODE_JOB(ts);
CREATE INDEX IDX_ODE_JOB_NODEID ON ODE_JOB(nodeid);

create table BPAF_EVENT (
    EID number(19,0) not null,
    ACTIVITY_DEFINITION_ID varchar2(255 char),
    ACTIVITY_INSTANCE_ID varchar2(255 char),
    ACTIVITY_NAME varchar2(255 char),
    CURRENT_STATE varchar2(255 char),
    PREVIOUS_STATE varchar2(255 char),
    PROCESS_DEFINITION_ID varchar2(255 char),
    PROCESS_INSTANCE_ID varchar2(255 char),
    PROCESS_NAME varchar2(255 char),
    SERVER_ID varchar2(255 char),
    TIMESTAMP number(19,0),
    primary key (EID)
    );

create table BPAF_EVENT_DATA (
    TID number(19,0) not null,
    NAME varchar2(255 char),
    VALUE varchar2(255 char),
    EVENT_ID number(19,0),
    primary key (TID)
);

alter table BPAF_EVENT_DATA
    add constraint FK3E83D1BCDA848C8
    foreign key (EVENT_ID)
    references BPAF_EVENT;