/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.tests.esb;

import org.jboss.soa.bpel.tests.RiftSawTest;
import org.jboss.soa.bpel.tests.RiftSawTestSetup;

import junit.framework.Test;

/**
 * Test case for running the Quickstart_bpel_hello_world sample modified to throw
 * an exception, related to RIFTSAW-491.
 */
public class QuickstartESBBPELHelloWorldExceptionTestCase extends RiftSawTest {

	// NOTE: Test is named after the bpel process, as that is where the exception is
	// thrown. Will reuse existing esb_bpel_hello_world ESB service to invoke the
	// exception generating BPEL process.
	private static final String TEST_NAME = "Quickstart_bpel_hello_world_exception";

	public QuickstartESBBPELHelloWorldExceptionTestCase() {
		super(TEST_NAME);
	}
	
	public static Test suite() {
		return(new RiftSawTestSetup(QuickstartESBBPELHelloWorldExceptionTestCase.class,
						TEST_NAME, "../Quickstart_esb_bpel_hello_world/Quickstart_esb_bpel_hello_world.esb,Quickstart_bpel_hello_world_exception-1.jar"));
	}

	public void testSendHello() throws Exception {
		
		try {
			String result=sendESBMessage("Hello World via ESB to BPEL", "HelloWorldBPELESB", "SayHello");
		
			fail("Shouldn't return a response");
		} catch(Exception e) {
			if (e.getCause() instanceof org.jboss.soa.esb.actions.ActionProcessingException) {
				if (!e.getCause().getMessage().equals("{http://www.jboss.org/bpel/examples}somethingBadHappened")) {
					fail("Cause message was not '{http://www.jboss.org/bpel/examples}somethingBadHappened': "+e.getCause().getMessage());
				}
			} else {
				fail("Unexpected exception: "+e+" with cause: "+e.getCause());
			}
		}
	}
}
