/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.tests.testcases;

import org.jboss.soa.bpel.tests.RiftSawTest;
import org.jboss.soa.bpel.tests.RiftSawTestSetup;

import junit.framework.Test;

/**
 * Test case for running the RiftSaw_372 testcase sample.
 */
public class RiftSaw372TestCase extends RiftSawTest {

	private static final String TEST_NAME = "RiftSaw_372";

	public RiftSaw372TestCase() {
		super(TEST_NAME);
	}
	
	public static Test suite() {
		return(new RiftSawTestSetup(RiftSaw372TestCase.class,
						TEST_NAME, "RiftSaw_372-1.jar"));
	}

	public void testSendHelloGoodbye() throws Exception {
		
		// Additional delay - this is the first test, and on loaded servers
		// it can sometimes fail if the BPEL process has not had time to be
		// compiled
		try {
			synchronized(this) {
				wait(30000);
			}
		} catch(Exception e) {
			e.printStackTrace();
		}
		
		String result1=sendSOAPMessage("hello_request1.xml",
				"http://localhost:8080/RiftSaw_372WS");

		result1 = processResult(result1);
		
		assertMessageFromFile(result1, "hello_response1.xml");
		
		String result2=sendSOAPMessage("goodbye_request1.xml",
				"http://localhost:8080/RiftSaw_372WS");
		
		result2 = processResult(result2);
		
		assertMessageFromFile(result2, "goodbye_response1.xml");
	}
}
