/*
 * Copyright 2001-2008 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */


package org.uddi.v3_service;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.Holder;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import org.uddi.sub_v3.DeleteSubscription;
import org.uddi.sub_v3.GetSubscriptionResults;
import org.uddi.sub_v3.Subscription;
import org.uddi.sub_v3.SubscriptionResultsList;


/**
 * This portType defines all of the UDDI subscription operations.
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.5-b03-
 * Generated source version: 2.1
 * 
 */
@WebService(name = "UDDI_Subscription_PortType", targetNamespace = "urn:uddi-org:v3_service")
@XmlSeeAlso({
    org.uddi.custody_v3.ObjectFactory.class,
    org.uddi.repl_v3.ObjectFactory.class,
    org.uddi.subr_v3.ObjectFactory.class,
    org.uddi.api_v3.ObjectFactory.class,
    org.uddi.vscache_v3.ObjectFactory.class,
    org.uddi.vs_v3.ObjectFactory.class,
    org.uddi.sub_v3.ObjectFactory.class,
    org.w3._2000._09.xmldsig_.ObjectFactory.class,
    org.uddi.policy_v3.ObjectFactory.class,
    org.uddi.policy_v3_instanceparms.ObjectFactory.class
})
public interface UDDISubscriptionPortType extends Remote{


    /**
     * 
     * @param body
     * @throws DispositionReportFaultMessage, RemoteException
     */
    @WebMethod(operationName = "delete_subscription", action = "delete_subscription")
    @SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
    public void deleteSubscription(
        @WebParam(name = "delete_subscription", targetNamespace = "urn:uddi-org:sub_v3", partName = "body")
        DeleteSubscription body)
        throws DispositionReportFaultMessage, RemoteException
    ;

    /**
     * 
     * @param body
     * @return
     *     returns org.uddi.sub_v3.SubscriptionResultsList
     * @throws DispositionReportFaultMessage, RemoteException
     */
    @WebMethod(operationName = "get_subscriptionResults", action = "get_subscriptionResults")
    @WebResult(name = "subscriptionResultsList", targetNamespace = "urn:uddi-org:sub_v3", partName = "body")
    @SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
    public SubscriptionResultsList getSubscriptionResults(
        @WebParam(name = "get_subscriptionResults", targetNamespace = "urn:uddi-org:sub_v3", partName = "body")
        GetSubscriptionResults body)
        throws DispositionReportFaultMessage, RemoteException
    ;

    /**
     * 
     * @param authInfo
     * @return
     *     returns java.util.List<org.uddi.sub_v3.Subscription>
     * @throws DispositionReportFaultMessage, RemoteException
     */
    @WebMethod(operationName = "get_subscriptions", action = "get_subscriptions")
    @WebResult(name = "subscription", targetNamespace = "urn:uddi-org:sub_v3")
    @RequestWrapper(localName = "get_subscriptions", targetNamespace = "urn:uddi-org:sub_v3", className = "org.uddi.sub_v3.GetSubscriptions")
    @ResponseWrapper(localName = "subscriptions", targetNamespace = "urn:uddi-org:sub_v3", className = "org.uddi.sub_v3.Subscriptions")
    public List<Subscription> getSubscriptions(
        @WebParam(name = "authInfo", targetNamespace = "urn:uddi-org:api_v3")
        String authInfo)
        throws DispositionReportFaultMessage, RemoteException
    ;

    /**
     * 
     * @param subscription
     * @param authInfo
     * @throws DispositionReportFaultMessage, RemoteException
     */
    @WebMethod(operationName = "save_subscription", action = "save_subscription")
    @RequestWrapper(localName = "save_subscription", targetNamespace = "urn:uddi-org:sub_v3", className = "org.uddi.sub_v3.SaveSubscription")
    @ResponseWrapper(localName = "subscriptions", targetNamespace = "urn:uddi-org:sub_v3", className = "org.uddi.sub_v3.Subscriptions")
    public void saveSubscription(
        @WebParam(name = "authInfo", targetNamespace = "urn:uddi-org:api_v3")
        String authInfo,
        @WebParam(name = "subscription", targetNamespace = "urn:uddi-org:sub_v3", mode = WebParam.Mode.INOUT)
        Holder<List<Subscription>> subscription)
        throws DispositionReportFaultMessage, RemoteException
    ;

}
