/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.message.filter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;

import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.filter.FilterManager;
import org.jboss.soa.esb.filter.InputOutputFilter;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerTagNames;
import org.jboss.soa.esb.listeners.ListenerUtil;
import org.jboss.soa.esb.message.Message;
import org.xml.sax.SAXException;

public class ServiceRouteFilter extends InputOutputFilter {	
	private String address = "127.0.0.1";
	
	private void startRoute(Message message, String serviceCategory, String serviceName) {
        try {
            address = InetAddress.getLocalHost().getHostName();
        } catch (final UnknownHostException uhe) {
        }
		
		String route = (String) message.getContext().getContext(Environment.MESSAGE_SERVICE_ROUTE);
					
		if (route == null) {
			message.getContext().setContext(Environment.MESSAGE_SERVICE_ROUTE,
				address + ":" + serviceCategory + ":" + serviceName);  	
		} else {
			message.getContext().removeContext(Environment.MESSAGE_SERVICE_ROUTE);
			message.getContext().setContext(Environment.MESSAGE_SERVICE_ROUTE,
					route + ", " + address + ":" + serviceCategory + ":" + serviceName + " started");
		}
	}

	private void endRoute(Message message, String serviceCategory, String serviceName) {					
        try {
                address = InetAddress.getLocalHost().getHostName();
        } catch (final UnknownHostException uhe) {
        }
		
		String route = (String) message.getContext().getContext(Environment.MESSAGE_SERVICE_ROUTE);
		
		if (route == null) {
			message.getContext().setContext(Environment.MESSAGE_SERVICE_ROUTE,
				address + ":" + serviceCategory + ":" + serviceName);  	
		} else {
			message.getContext().removeContext(Environment.MESSAGE_SERVICE_ROUTE);
			message.getContext().setContext(Environment.MESSAGE_SERVICE_ROUTE,
				route + ", " + address + ":" + serviceCategory + ":" + serviceName + " ended");
		}
	}
	
	@Override
	public Message onOutput(Message msg, Map<String, Object> params) throws CourierException
	{
		boolean messageRecordRoutes = Boolean.parseBoolean(
				(String) msg.getProperties().getProperty(ListenerTagNames.SERVICE_RECORD_ROUTE_TAG,
						"false")
				);		
		
	    ConfigTree config = null;
		if (params != null) {
			if (params.get(Environment.GATEWAY_CONFIG) instanceof ConfigTree) {
				config = (ConfigTree) params.get(Environment.GATEWAY_CONFIG);
			} else {	
	        	String gatewayConfig = (String) params.get(Environment.GATEWAY_CONFIG);
				try {
					config = ConfigTree.fromInputStream(new ByteArrayInputStream(gatewayConfig.getBytes()));
				} catch (SAXException e) {
					throw new CourierException(e);
				} catch (IOException e) {
					throw new CourierException(e);
				}
			}
        }

        if (config != null) {
        	final String serviceCategory = ListenerUtil.getValue(config, ListenerTagNames.TARGET_SERVICE_CATEGORY_TAG);
        	final String serviceName = ListenerUtil.getValue(config, ListenerTagNames.TARGET_SERVICE_NAME_TAG);

    	   	boolean serviceRoute = Boolean.parseBoolean((String) 
    	   			ListenerUtil.getValue(config, ListenerTagNames.SERVICE_RECORD_ROUTE_TAG, "false"));
    	   	boolean messageRoute = Boolean.parseBoolean((String)
    				msg.getProperties().getProperty(ListenerTagNames.SERVICE_RECORD_ROUTE_TAG, "false"));
    	    	
    		if (serviceRoute || messageRoute) {		
    			endRoute(msg, serviceCategory, serviceName);
    		}
    			
        	FilterManager._logger.info("ServiceRouteFilter: " + serviceCategory + ":" + serviceName + " ended");
        }
		
		return msg;
	}
	
	@Override
	public Message onInput(Message msg, Map<String, Object> params) throws CourierException
	{
		boolean messageRecordRoutes = Boolean.parseBoolean(
				(String) msg.getProperties().getProperty(ListenerTagNames.SERVICE_RECORD_ROUTE_TAG,
						"false")
				);		

	    ConfigTree config = null;
		if (params != null) {
			if (params.get(Environment.GATEWAY_CONFIG) instanceof ConfigTree) {
				config = (ConfigTree) params.get(Environment.GATEWAY_CONFIG);
			} else {	
	        	String gatewayConfig = (String) params.get(Environment.GATEWAY_CONFIG);
				try {
					config = ConfigTree.fromInputStream(new ByteArrayInputStream(gatewayConfig.getBytes()));
				} catch (SAXException e) {
					throw new CourierException(e);
				} catch (IOException e) {
					throw new CourierException(e);
				}
			}
		}

    	if (config != null) {
    	    final String serviceCategory = ListenerUtil.getValue(config, ListenerTagNames.TARGET_SERVICE_CATEGORY_TAG);
    	    final String serviceName = ListenerUtil.getValue(config, ListenerTagNames.TARGET_SERVICE_NAME_TAG);    	    	

    	    boolean serviceRoute = Boolean.parseBoolean((String) 
    	  	ListenerUtil.getValue(config, ListenerTagNames.SERVICE_RECORD_ROUTE_TAG, "false"));
    	    boolean messageRoute = Boolean.parseBoolean((String)
    	    msg.getProperties().getProperty(ListenerTagNames.SERVICE_RECORD_ROUTE_TAG, "false"));

    		if (serviceRoute || messageRoute) {		
      	        startRoute(msg, serviceCategory, serviceName);
    		}
    	    	
    	    FilterManager._logger.info("ServiceRouteFilter: " + serviceCategory + ":" + serviceName + " started");
    	}			
	
		return msg;
	}	
}