/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.internal.soa.esb.util;

/**
 * Exception used for LRUReferenceCountCache
 */
public class LRUReferenceCountException extends Exception
{
    /**
     * Serial version UID.
     */
    private static final long serialVersionUID = 4726344597058554887L;

    /**
     * Construct a default lru reference count exception.
     */
    public LRUReferenceCountException()
    {
    }

    /**
     * Construct a lru reference count exception with a specific message.
     * @param message the associated message.
     */
    public LRUReferenceCountException(final String message)
    {
        super(message) ;
    }

    /**
     * Construct a lru reference count exception with a specific cause.
     * @param cause the associated cause.
     */
    public LRUReferenceCountException(final Throwable cause)
    {
        super(cause) ;
    }

    /**
     * Construct a lru reference count exception with a specific message and cause.
     * @param message the associated message.
     * @param cause the associated cause.
     */
    public LRUReferenceCountException(final String message, final Throwable cause)
    {
        super(message, cause) ;
    }
}
