/*
 * JBoss, Home of Professional Open Source
 * Copyright 2012, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2012,
 * @author JBoss Inc.
 */
package org.jboss.soa.esb.actions.aggregator;

import java.util.TreeMap;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Body;
import org.jboss.soa.esb.message.Message;

/**
 * Concrete implementation of the AbstractAggregator class which 
 * stores te messages.
 * 
 * @author Kevin Conner
 */
public class StreamingAggregator extends AbstractAggregator
{
    public StreamingAggregator(final ConfigTree config)
        throws ConfigurationException
    {
        super(config) ;
    }

    @Override
    protected boolean aggregateMessage(final Message aggregatedMessage, final Integer messageSequence, final Message currentMessage)
        throws ActionProcessingException
    {
        final Body body = aggregatedMessage.getBody() ;
        TreeMap<Integer, Object> aggregatedMessages = (TreeMap<Integer, Object>) body.get() ;
        if (aggregatedMessages == null)
        {
            aggregatedMessages = new TreeMap<Integer, Object>() ;
            body.add(aggregatedMessages) ;
        }
        final Object original = aggregatedMessages.put(messageSequence, currentMessage.getBody().get())  ;
        if (original != null)
        {
            aggregatedMessages.put(messageSequence, original) ;
            return false ;
        }
        else
        {
            return true ;
        }
    }

}
