/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.deployers.mc.util;

import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;

/**
 * A {@link VirtualFileFilter} implementation that takes a suffix as a parameter to its 
 * constructor.
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 *
 */
public class VfsFileFilter implements VirtualFileFilter
{
    private final String suffix;
    
    /**
     * Creates a instance using the passed in suffix
     * @param suffix The suffix for this filter. 
     * 
     * @throws IllegalArgumentException If the passed in suffix is null.
     */
    public VfsFileFilter(final String suffix)
    {
        if (suffix == null)
            throw new IllegalArgumentException("suffix argument must not be null");
            
        this.suffix = suffix;
        
    }
    
    /**
     * Accepts only files ending with the suffix.
     * 
     * @param file  The file to filter.
     * @return true If the file name ends with suffix.
     */
    public boolean accepts(final VirtualFile file)
    {
        return file.getName().endsWith(suffix);
    }
    
    public String getSuffix()
    {
        return suffix;
    }
}
