/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.notification;

import java.util.Properties;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.NamingException;

import org.jboss.internal.soa.esb.rosetta.pooling.ConnectionException;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPool;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.NamingContextException;
import org.jboss.soa.esb.helpers.NamingContextPool;
/**
 * 
 * KS: It is silly we open and close the jms connection with eash request.
 * @author John Doe
 *
 */
public class NotifyTopics extends NotifyJMS
{

	public static final String CHILD_TOPIC = "topic";

	public NotifyTopics (ConfigTree p_oP) throws ConfigurationException, JMSException, ConnectionException
	{
		super(p_oP);

		setUpProducers(p_oP.getChildren(CHILD_TOPIC));
	} // __________________________________

	protected void send (final Message p_oMsg, MessageProducer msgProducer ) throws JMSException
	{
		msgProducer.send(p_oMsg);
	}
	
	protected MessageProducer createProducer(
			final JmsConnectionPool pool, 
			final String destinationName, 
			final Session session,
			final Properties environment) throws NamingException, JMSException, ConnectionException
	{
	try
	{
            Context context = NamingContextPool.getNamingContext(environment);
            try
            {
                Destination destination=null;
                try 
                {
                    destination = (Destination) context.lookup(destinationName);
                } 
                catch (NamingException ne) 
                {
                    context = NamingContextPool.replaceNamingContext(context, environment);
                    try 
                    {
                        destination = (Destination) context.lookup(destinationName);
                    } 
                    catch (NamingException nex) 
                    {
                        //ActiveMQ
                        session.createTopic(destinationName);
                    }
                }
    		return session.createProducer(destination);
            }
            finally
            {
                NamingContextPool.releaseNamingContext(context) ;
            }
	}
	catch (final NamingContextException nce)
	{
	    throw new ConnectionException("Unexpected exception while accessing naming context pool", nce) ;
	}
	}
	
} // ____________________________________________________________________________
