/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.util.embedded.ftp;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;

import org.apache.log4j.Logger;

/**
 * Util methods created for embedded FTP server test
 * 
 * @author Daniel Bevenius
 *
 */
public class FtpTestUtil
{
	private static Logger log = Logger.getLogger( FtpTestUtil.class );
	
	private FtpTestUtil() { }
	
	/**
	 * Can be used to test the embedded ftp server 
	 * with a local client.  Useful for debugging when you need to know
	 * what a specific command does on the ftp server ( like CWD )
	 * 
	 * Add a call to this method in youre test method
	 * and you can start a local ftp client that connects to the
	 * embedded ftp server. 
	 *
	 */
	public static void promptForQuit()
	{
		System.out.println( "Enter q to quit:" );
		Scanner scanner = new Scanner( System.in );
		scanner.hasNext( "q" );
	}
	
	public static boolean deleteFile( File file )
	{
		if ( file != null && file.exists() )
		{
			return file.delete();
		}
		return true; 
	}
	
	public static boolean deleteDir( File dir )
	{
		if ( dir.isDirectory() ) 
		{
            String[] filesInDir = dir.list();
            for ( String fileName : filesInDir )
            {
                if ( ! ( deleteDir( new File( dir, fileName ) ) ) ) 
                    return false;
            }
		}
		return dir.delete();
	}
	
	public static File createTestFile( final File dir, final String fileName, final String fileContents )
	{
		return createTestFile( dir.getAbsolutePath() + File.separator + fileName, fileContents );
	}

	public static File createTestFile( final String fileName, String fileContents)
	{
		File testFile = new File ( fileName );
		FileWriter writer = null;
		try
		{
			testFile.createNewFile();
			writer = new FileWriter( testFile );
			writer.write( fileContents );
		} 
		catch (IOException e)
		{
			log.error ( e.getMessage() );
		} 
		finally
		{
			close( writer );
		}
		return testFile;
	}

	public static File createTestDirectory(final String directoryName)
	{
		File testFile = new File (directoryName);
		try
		{
			testFile.mkdir();
		} 
		catch (Exception e)
		{
			log.error ( e.getMessage() );
		} 
		return testFile;
	}
	
	public static void close( Closeable c )
	{
		if (c != null)
		{
			try
			{
				c.close();
			} catch (IOException e)
			{
				log.warn( e );
				/* ignore */
			}
		}
	}

}
