/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.addressing.util.tests;

import java.net.URI;
import java.net.URISyntaxException;

import junit.framework.TestCase;

import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.addressing.helpers.EPRHelper;
import org.jboss.soa.esb.MarshalException;
import org.jboss.soa.esb.UnmarshalException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.eprs.EmailEpr;
import org.jboss.soa.esb.addressing.eprs.InVMEpr;
import org.jboss.soa.esb.message.tests.XMLMessageUnitTest;

/**
 * Unit tests for the Class class.
 * 
 * @author Mark Little
 */

public class EPRHelperUnitTest extends TestCase
{
	private Logger log = Logger.getLogger( XMLMessageUnitTest.class );
	
	public void testToFromXMLString () throws MarshalException, UnmarshalException
	{
		EmailEpr email = new EmailEpr(EmailEpr.SMTP_PROTOCOL, "foobar", "25", "me", "letmein");
		
		String xmlString = EPRHelper.toXMLString(email);
		
		log.debug("xmlString is: "+xmlString);
		
		EPR epr = EPRHelper.fromXMLString(xmlString);
		
		if (epr instanceof EmailEpr)
		{
		}
		else
		    fail();
	}
	
    public void testModification()
        throws URISyntaxException, MarshalException
    {
        final InVMEpr epr = new InVMEpr(URI.create(InVMEpr.INVM_PROTOCOL + "://thread-" + Thread.currentThread().getId())) ;
        final InVMEpr clone = new InVMEpr(epr) ;
        final String xml = EPRHelper.toXMLString(epr) ;
        assertEquals("EPR modified", clone, epr) ;
    }
}
