/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.helpers;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

/**
 * Unit tests for the KeyValuePair class.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class KeyValuePairUnitTest extends TestCase {

	public void test_Constructor_args() {
		try {
			new KeyValuePair(null, "aaa");
			fail("Expected IllegalArgumentException");
		} catch(IllegalArgumentException e) {
			// expected
		}
		try {
			new KeyValuePair(" ", "aaa");
			fail("Expected IllegalArgumentException");
		} catch(IllegalArgumentException e) {
			// expected
		}
		new KeyValuePair("a", "aaa");
		new KeyValuePair("a", null);
		new KeyValuePair("a", "");
	}

	public void test_methods() {
		KeyValuePair kvp = new KeyValuePair("key", "value");
		
		assertEquals("key", kvp.getKey());
		assertEquals("value", kvp.getValue());
		assertEquals("value", kvp.toString());
		assertEquals("KVpair[key=value]", kvp.dump());
	}

    public void test_list() {
        List<KeyValuePair> list = new ArrayList<KeyValuePair>();
        
        list.add(new KeyValuePair("key1", "value1"));
        list.add(new KeyValuePair("key2", "true"));
        list.add(new KeyValuePair("key3", "false"));
        list.add(new KeyValuePair("key4", "2"));
        list.add(new KeyValuePair("key5", "10.8"));

        assertEquals("value1", KeyValuePair.getValue("key1", list));
        assertEquals("true", KeyValuePair.getValue("key2", list));
        assertEquals("false", KeyValuePair.getValue("key3", list));
        assertEquals("2", KeyValuePair.getValue("key4", list));

        assertEquals(true, KeyValuePair.getBooleanValue("key2", list, false));
        assertEquals(false, KeyValuePair.getBooleanValue("key3", list, true));
        assertEquals(true, KeyValuePair.getBooleanValue("key1", list, true));

        assertEquals(2.0, KeyValuePair.getDoubleValue("key4", list, 10.0));
        assertEquals(10.8, KeyValuePair.getDoubleValue("key5", list, 2.0));
        assertEquals(100.0, KeyValuePair.getDoubleValue("key1", list, 100.0));
    }
}
