package org.jboss.soa.esb.listeners.gateway.remotestrategies;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.File;

import junit.framework.JUnit4TestAdapter;

import org.apache.log4j.Logger;
import org.jboss.cache.CacheException;
import org.jboss.soa.esb.listeners.gateway.remotestrategies.cache.FtpFileCacheTestUtil;
import org.jboss.soa.esb.testutils.HsqldbUtil;
import org.jboss.soa.esb.testutils.TestEnvironmentUtil;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * 
 * The test requires a network connection to pass.<br>
 * If you are running on linux you can use:<br>
 * route add -net 224.0.0.0 netmask 240.0.0.0 dev lo
 * @author <a href="daniel.bevenius@redpill.se">Daniel Bevenius</a>				
 *
 */
public class ReadOnlyRemoteFileSystemStrategyManual
{
	private static Logger log = Logger .getLogger( ReadOnlyRemoteFileSystemStrategyManual.class );
	
	private static ReadOnlyRemoteFileSystemStrategy strategy;

	private static ReadOnlyRemoteFileSystemStrategy strategy2;
	
	private static Object server;
	
	private String testFile1 = "testFile1";
	private String testFile2 = "testFile2";
	private String testFile3 = "testFile3";
	
	private File[] expectedFileList = new File[] { new File( testFile1 ) , new File( testFile2 ) };
	private File[] newFileList = new File[] { new File( testFile3 ) };
	private File[] emptyFileList = new File[] {};
	
	@Test
	public void listFilesNegative() 
	{
		try
		{
			strategy.filterFileList( null );
		} 
		catch (RemoteFileSystemStrategyException e)
		{
			fail("Should be ok to pass null as the file array!");
		}
	}
	
	@Test
	public void listFiles() throws RemoteFileSystemStrategyException 
	{
		File[] filteredFileList = strategy.filterFileList( expectedFileList );
		assertEquals( expectedFileList, filteredFileList );
		
		filteredFileList = strategy.filterFileList( expectedFileList );
		assertEquals( "No files should have been returned. They should have been cached.", emptyFileList, filteredFileList );
		
		filteredFileList = strategy.filterFileList( newFileList );
		assertEquals( newFileList, filteredFileList );
		assertTrue ( filteredFileList instanceof File[] );
	}
	
	@Test
	public void listFiles_With_Two_Strategy_Instances() throws Exception 
	{
		
		try
		{
			File[] filteredFileList = strategy2.filterFileList( expectedFileList );
			assertEquals( expectedFileList, filteredFileList );
			
			filteredFileList = strategy.filterFileList( expectedFileList );
			assertEquals( emptyFileList, filteredFileList );
			
			filteredFileList = strategy2.filterFileList( newFileList );
			assertEquals( newFileList, filteredFileList );
			
			filteredFileList = strategy.filterFileList( newFileList );
			assertEquals( emptyFileList, filteredFileList );
			
		}
		catch ( Exception e )
		{
			log.error(e);
		}
		finally
		{
			strategy2.stop();
		}
		
	}
	
	@Before
	public void setup() throws CacheException
	{
		strategy.removeAllData();
	}
	
	@BeforeClass
	public static void classSetup() throws Exception
	{
		registerHsqlDriver();
		server = HsqldbUtil.startHsqldb(TestEnvironmentUtil.getUserDir() + "build" + File.separator + "hsqltestdb", "ftpcache");
		
		strategy = new ReadOnlyRemoteFileSystemStrategy();
		strategy.init( FtpFileCacheTestUtil.getCacheConfigFile() );
		
		strategy2 = new ReadOnlyRemoteFileSystemStrategy();
		strategy2.init( FtpFileCacheTestUtil.getCacheConfigFile() );
	}
		
	private static void registerHsqlDriver()
	{
		try 
		{
			Class.forName( "org.hsqldb.jdbcDriver" );
		} 
		catch (Exception e) 
		{
			fail( "ERROR: failed to load JDBC driver." + e.getMessage() );
		}
	}
	
	@AfterClass
	public static void classTearDown() throws Exception
	{
		strategy.stop();
		strategy2.stop();
                HsqldbUtil.stopHsqldb(server);
	}
	
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter(ReadOnlyRemoteFileSystemStrategyManual.class);
	}
}
