/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.principals;

import static org.junit.Assert.*;
import org.junit.Test;
import junit.framework.JUnit4TestAdapter;

/**
 * Unit test for {@link Role}
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@redhat.com">Daniel Bevenius</a>
 *
 */
public class GroupUnitTest
{
	private Group groupOne = new Group("groupOne");
	private Group group1 = new Group("groupOne");
	private Group groupTwo = new Group("groupTwo");
	private Group group2 = new Group("groupTwo");
	
	@Test (expected = NullPointerException.class)
	public void constuctWithNullGroupName()
	{
		new Group(null);
	}

	@Test
	public void equals()
	{
		groupOne.addMember(new Role("role1"));
		assertFalse(group1.equals(groupOne));
		assertFalse(groupOne.equals(group1));
		assertFalse(groupOne.equals(group2));
		group1.addMember(new Role("role1"));
		assertEquals(groupOne, group1);
	}
	
	@Test
	public void hashcode()
	{
		assertEquals(groupOne.hashCode(), group1.hashCode());
		assertFalse(groupOne.hashCode() == groupTwo.hashCode());
	}
	
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter(GroupUnitTest.class);
	}
}
