/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.internal.soa.esb.soap.cxf;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;

/**
 * A jbossws deployment aspect that creates an extension bag attached to the endpoints.
 *
 * @author <a href='mailto:kevin.conner@jboss.com>Kevin Conner</a>
 */
public class ExtensionDeploymentAspect extends DeploymentAspect
{
   @Override
   public void start(Deployment dep)
   {
       for (Endpoint endpoint : dep.getService().getEndpoints())
       {
           endpoint.addAttachment(Map.class, new ConcurrentHashMap<Object, Object>()) ;
       }
   }

   @Override
   public void stop(Deployment dep)
   {
       for (Endpoint endpoint : dep.getService().getEndpoints())
       {
           endpoint.removeAttachment(Map.class) ;
       }
   }
}
